function(__addIcon THEME ICON_NAME)
    set(options)
    set(oneValueArgs SRC_PATH)
    set(multiValueArgs)
    cmake_parse_arguments(_ICON "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

    if(NOT _ICON_SRC_PATH)
        set(_ICON_SRC_PATH ${THEME})
    endif()

    set(icon "theme/${_ICON_SRC_PATH}/${ICON_NAME}.svg")
    set(iconAlias "theme/${THEME}/${ICON_NAME}.svg")
    if (EXISTS ${OEM_THEME_DIR}/${icon})
        file(APPEND "${QRC}" "<file alias=\"${iconAlias}\">${OEM_THEME_DIR}/${icon}</file>\n")
    else()
        set(icon "theme/${_ICON_SRC_PATH}/${ICON_NAME}.png")
        set(iconAlias "theme/${THEME}/${ICON_NAME}.png")
        if (EXISTS ${OEM_THEME_DIR}/${icon})
            file(APPEND "${QRC}" "<file alias=\"${iconAlias}\">${OEM_THEME_DIR}/${icon}</file>\n")
        else()
            set(SIZES "16;22;32;48;64;128;256;512;1024")
            foreach(size ${SIZES})
                set(icon "theme/${_ICON_SRC_PATH}/${ICON_NAME}-${size}.png")
                set(iconAlias "theme/${THEME}/${ICON_NAME}-${size}.png")
                if (EXISTS ${OEM_THEME_DIR}/${icon})
                    file(APPEND "${QRC}" "<file alias=\"${iconAlias}\">${OEM_THEME_DIR}/${icon}</file>\n")
                endif()
            endforeach()
        endif()
    endif()
endfunction()

function(generate_theme TARGET OWNCLOUD_SIDEBAR_ICONS_OUT)
    if(NOT "${OEM_THEME_DIR}" STREQUAL "${PROJECT_SOURCE_DIR}")
        set(QRC ${CMAKE_BINARY_DIR}/theme.qrc)
        file(WRITE "${QRC}" "<RCC>\n<qresource prefix=\"/client/${APPLICATION_SHORTNAME}\">\n")
        __addIcon("universal" "${APPLICATION_ICON_NAME}-icon" SRC_PATH "colored")
        __addIcon("universal" "wizard_logo" SRC_PATH "colored")

        set(STATES "ok;error;information;offline;pause;sync")
        set(THEMES "colored;dark;black;white")
        foreach(theme ${THEMES})
            foreach(state ${STATES})
                __addIcon(${theme} "state-${state}")
            endforeach()
        endforeach()
        file(APPEND "${QRC}" "</qresource>\n</RCC>\n")
        target_sources(${TARGET} PRIVATE ${QRC})
        # add executable icon on windows and osx
        file(GLOB_RECURSE OWNCLOUD_SIDEBAR_ICONS "${OEM_THEME_DIR}/theme/colored/*-${APPLICATION_ICON_NAME}-sidebar.png")
    else()
        file(GLOB_RECURSE OWNCLOUD_SIDEBAR_ICONS "${OEM_THEME_DIR}/theme/colored/*-${APPLICATION_ICON_NAME}-icon-sidebar.png")
    endif()
    set(${OWNCLOUD_SIDEBAR_ICONS_OUT} ${OWNCLOUD_SIDEBAR_ICONS} PARENT_SCOPE)
endfunction()


function(generate_legacy_icons theme_dir OUT)
    # allow legacy file names
    file(GLOB_RECURSE OWNCLOUD_ICONS_OLD "${theme_dir}/colored/${APPLICATION_ICON_NAME}-icon-*.png")
    foreach(icon ${OWNCLOUD_ICONS_OLD})
        get_filename_component(icon_name ${icon} NAME)
        string(REGEX MATCH "([0-9]+)" size ${icon_name})
        set(out_name "${CMAKE_BINARY_DIR}/${size}-app-icon.png")
        configure_file(${icon} ${out_name} COPYONLY)
        list(APPEND OWNCLOUD_ICONS ${out_name})
    endforeach()
    set(${OUT} ${OWNCLOUD_ICONS} PARENT_SCOPE)
endfunction()
