/**
 *  \file gemv.c
 *  \brief OSKI wrapper around the dense BLAS routine, xGEMV.
 *  \ingroup AUXIL
 *
 *  Generated by ./gen_gemv.sh on airassualt, Thu Jun 30 19:00:01 PDT 2005.
 */

#include <oski/config.h>
#include <oski/common.h>
#include <oski/mangle.h>
#include <oski/blas.h>
#include <oski/blas_names.h>

#if !HAVE_BLAS

static void
xGEMV_Normal (oski_index_t m, oski_index_t n, oski_value_t alpha,
	      const oski_value_t * restrict A, oski_index_t lda,
	      const oski_value_t * restrict x, oski_index_t incx,
	      oski_value_t * restrict y, oski_index_t incy)
{
  if (incy == 1)
    {
      if (IS_VAL_ONE (alpha))
	{

	  oski_index_t j;
	  const oski_value_t *xp;

	  for (j = 0, xp = x; j < n; j++, xp += incx)
	    {
	      oski_value_t x0;

	      oski_index_t i;
	      const oski_value_t *ap = A + j * lda;
	      oski_value_t *yp;
	      VAL_ASSIGN (x0, xp[0]);;
	      for (i = 0, yp = y; i < m; i++, yp++, ap++)
		{
		  oski_value_t y0;
		  ;
		  VAL_MUL (y0, ap[0], x0);
		  VAL_INC (yp[0], y0);
		}
	      ;
	    }

	}
      else if (IS_VAL_NEG_ONE (alpha))
	{

	  oski_index_t j;
	  const oski_value_t *xp;

	  for (j = 0, xp = x; j < n; j++, xp += incx)
	    {
	      oski_value_t x0;

	      oski_index_t i;
	      const oski_value_t *ap = A + j * lda;
	      oski_value_t *yp;
	      VAL_ASSIGN (x0, xp[0]);;
	      for (i = 0, yp = y; i < m; i++, yp++, ap++)
		{
		  oski_value_t y0;
		  ;
		  VAL_MUL (y0, ap[0], x0);
		  VAL_DEC (yp[0], y0);
		}
	      ;
	    }

	}
      else			/* general alpha */
	{

	  oski_index_t j;
	  const oski_value_t *xp;

	  for (j = 0, xp = x; j < n; j++, xp += incx)
	    {
	      oski_value_t x0;

	      oski_index_t i;
	      const oski_value_t *ap = A + j * lda;
	      oski_value_t *yp;
	      VAL_ASSIGN (x0, xp[0]);
	      VAL_SCALE (x0, alpha);
	      for (i = 0, yp = y; i < m; i++, yp++, ap++)
		{
		  oski_value_t y0;
		  ;
		  VAL_MUL (y0, ap[0], x0);
		  VAL_INC (yp[0], y0);
		}
	      ;
	    }

	}
    }
  else				/* general incy */
    {
      if (IS_VAL_ONE (alpha))
	{

	  oski_index_t j;
	  const oski_value_t *xp;

	  for (j = 0, xp = x; j < n; j++, xp += incx)
	    {
	      oski_value_t x0;

	      oski_index_t i;
	      const oski_value_t *ap = A + j * lda;
	      oski_value_t *yp;
	      VAL_ASSIGN (x0, xp[0]);;
	      for (i = 0, yp = y; i < m; i++, yp += incy, ap++)
		{
		  oski_value_t y0;
		  ;
		  VAL_MUL (y0, ap[0], x0);
		  VAL_INC (yp[0], y0);
		}
	      ;
	    }

	}
      else if (IS_VAL_NEG_ONE (alpha))
	{

	  oski_index_t j;
	  const oski_value_t *xp;

	  for (j = 0, xp = x; j < n; j++, xp += incx)
	    {
	      oski_value_t x0;

	      oski_index_t i;
	      const oski_value_t *ap = A + j * lda;
	      oski_value_t *yp;
	      VAL_ASSIGN (x0, xp[0]);;
	      for (i = 0, yp = y; i < m; i++, yp += incy, ap++)
		{
		  oski_value_t y0;
		  ;
		  VAL_MUL (y0, ap[0], x0);
		  VAL_DEC (yp[0], y0);
		}
	      ;
	    }

	}
      else			/* general alpha */
	{

	  oski_index_t j;
	  const oski_value_t *xp;

	  for (j = 0, xp = x; j < n; j++, xp += incx)
	    {
	      oski_value_t x0;

	      oski_index_t i;
	      const oski_value_t *ap = A + j * lda;
	      oski_value_t *yp;
	      VAL_ASSIGN (x0, xp[0]);
	      VAL_SCALE (x0, alpha);
	      for (i = 0, yp = y; i < m; i++, yp += incy, ap++)
		{
		  oski_value_t y0;
		  ;
		  VAL_MUL (y0, ap[0], x0);
		  VAL_INC (yp[0], y0);
		}
	      ;
	    }

	}
    }
}

static void
xGEMV_Trans (oski_index_t m, oski_index_t n, oski_value_t alpha,
	     const oski_value_t * restrict A, oski_index_t lda,
	     const oski_value_t * restrict x, oski_index_t incx,
	     oski_value_t * restrict y, oski_index_t incy)
{
  if (incx == 1)
    {
      if (IS_VAL_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp++, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_INC (yp[0], y0);
	    }

	}
      else if (IS_VAL_NEG_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp++, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_DEC (yp[0], y0);
	    }

	}
      else			/* general alpha */
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp++, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC (y0, ap[0], x0);
		  ;
		}
	      VAL_SCALE (y0, alpha);
	      VAL_INC (yp[0], y0);
	    }

	}
    }
  else				/* general incx */
    {
      if (IS_VAL_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp += incx, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_INC (yp[0], y0);
	    }

	}
      else if (IS_VAL_NEG_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp += incx, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_DEC (yp[0], y0);
	    }

	}
      else			/* general alpha */
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp += incx, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC (y0, ap[0], x0);
		  ;
		}
	      VAL_SCALE (y0, alpha);
	      VAL_INC (yp[0], y0);
	    }

	}
    }
}

#if IS_VAL_COMPLEX
static void
xGEMV_ConjTrans (oski_index_t m, oski_index_t n, oski_value_t alpha,
		 const oski_value_t * restrict A, oski_index_t lda,
		 const oski_value_t * restrict x, oski_index_t incx,
		 oski_value_t * restrict y, oski_index_t incy)
{
  if (incx == 1)
    {
      if (IS_VAL_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp++, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC_CONJ (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_INC (yp[0], y0);
	    }

	}
      else if (IS_VAL_NEG_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp++, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC_CONJ (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_DEC (yp[0], y0);
	    }

	}
      else			/* general alpha */
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp++, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC_CONJ (y0, ap[0], x0);
		  ;
		}
	      VAL_SCALE (y0, alpha);
	      VAL_INC (yp[0], y0);
	    }

	}
    }
  else				/* general incx */
    {
      if (IS_VAL_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp += incx, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC_CONJ (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_INC (yp[0], y0);
	    }

	}
      else if (IS_VAL_NEG_ONE (alpha))
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp += incx, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC_CONJ (y0, ap[0], x0);
		  ;
		}
	      ;
	      VAL_DEC (yp[0], y0);
	    }

	}
      else			/* general alpha */
	{

	  oski_index_t i;
	  oski_value_t *yp;

	  for (i = 0, yp = y; i < n; i++, yp += incy)
	    {
	      oski_value_t y0;

	      oski_index_t j;
	      const oski_value_t *ap = A + i * lda;
	      const oski_value_t *xp;
	      VAL_SET_ZERO (y0);
	      for (j = 0, xp = x; j < m; j++, xp += incx, ap++)
		{
		  oski_value_t x0;
		  VAL_ASSIGN (x0, xp[0]);
		  VAL_MAC_CONJ (y0, ap[0], x0);
		  ;
		}
	      VAL_SCALE (y0, alpha);
	      VAL_INC (yp[0], y0);
	    }

	}
    }
}

#endif


void
BLAS_xGEMV (const char *op, const oski_index_t * m, const oski_index_t * n,
	    const oski_value_t * alpha,
	    const oski_value_t * A, const oski_index_t * lda,
	    const oski_value_t * x, const oski_index_t * incx,
	    const oski_value_t * beta, oski_value_t * y,
	    const oski_index_t * incy)
{
  /* Quick return, if possible. */
  if (*m == 0 || *n == 0 || (IS_VAL_ZERO (alpha[0]) && IS_VAL_ONE (beta[0])))
    return;

  switch (op[0])
    {
    case 'n':
    case 'N':
      xGEMV_Normal (*m, *n, *alpha, A, *lda, x, *incx, y, *incy);
      break;

    case 'c':
    case 'C':
#if IS_VAL_COMPLEX
      xGEMV_ConjTrans (*m, *n, *alpha, A, *lda, x, *incx, y, *incy);
      break;
#endif
    case 't':
    case 'T':
      xGEMV_Trans (*m, *n, *alpha, A, *lda, x, *incx, y, *incy);
      break;

    default:
      OSKI_ERR_BAD_MATOP (BLAS_xGEMV, 1, op[0]);
      break;
    }
}

#endif

/* eof */
