
/**
 *  \file src/CSR/MatMult/CSR_MatMult.h
 *  \ingroup MATTYPE_CSR
 *  \brief CSR sparse matrix-vector multiply implementation
 *  in the non-symmetric/non-Hermitian case.
 *
 *  Automatically generated by ./gen_csr_nonsymm.sh and ../../../build/gen/driver/oski_spgen
 *  on Tue Nov 23 15:06:01 PST 2004.
 */

#if !defined(INC_CSR_MatMult)
/** src/CSR/MatMult/CSR_MatMult.h included. */
#define INC_CSR_MatMult



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatMult_v1_aN1_b1_xs1_ysX() */
#define CSR_MatMult_v1_aN1_b1_xs1_ysX \
	MANGLE_(CSR_MatMult_v1_aN1_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aN1_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatMult_v1_aN1_b1_xsX_ysX() */
#define CSR_MatMult_v1_aN1_b1_xsX_ysX \
	MANGLE_(CSR_MatMult_v1_aN1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aN1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatMult_v1_a1_b1_xs1_ysX() */
#define CSR_MatMult_v1_a1_b1_xs1_ysX \
	MANGLE_(CSR_MatMult_v1_a1_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_a1_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatMult_v1_a1_b1_xsX_ysX() */
#define CSR_MatMult_v1_a1_b1_xsX_ysX \
	MANGLE_(CSR_MatMult_v1_a1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_a1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatMult_v1_aX_b1_xs1_ysX() */
#define CSR_MatMult_v1_aX_b1_xs1_ysX \
	MANGLE_(CSR_MatMult_v1_aX_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aX_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatMult_v1_aX_b1_xsX_ysX() */
#define CSR_MatMult_v1_aX_b1_xsX_ysX \
	MANGLE_(CSR_MatMult_v1_aX_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aX_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatTransMult_v1_aN1_b1_xsX_ys1() */
#define CSR_MatTransMult_v1_aN1_b1_xsX_ys1 \
	MANGLE_(CSR_MatTransMult_v1_aN1_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatTransMult_v1_aN1_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatTransMult_v1_aN1_b1_xsX_ysX() */
#define CSR_MatTransMult_v1_aN1_b1_xsX_ysX \
	MANGLE_(CSR_MatTransMult_v1_aN1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatTransMult_v1_aN1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatTransMult_v1_a1_b1_xsX_ys1() */
#define CSR_MatTransMult_v1_a1_b1_xsX_ys1 \
	MANGLE_(CSR_MatTransMult_v1_a1_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatTransMult_v1_a1_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatTransMult_v1_a1_b1_xsX_ysX() */
#define CSR_MatTransMult_v1_a1_b1_xsX_ysX \
	MANGLE_(CSR_MatTransMult_v1_a1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatTransMult_v1_a1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatTransMult_v1_aX_b1_xsX_ys1() */
#define CSR_MatTransMult_v1_aX_b1_xsX_ys1 \
	MANGLE_(CSR_MatTransMult_v1_aX_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatTransMult_v1_aX_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING)
/** Mangled name for CSR_MatTransMult_v1_aX_b1_xsX_ysX() */
#define CSR_MatTransMult_v1_aX_b1_xsX_ysX \
	MANGLE_(CSR_MatTransMult_v1_aX_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is real-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatTransMult_v1_aX_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatMult_v1_aN1_b1_xs1_ysX() */
#define CSR_MatMult_v1_aN1_b1_xs1_ysX \
	MANGLE_(CSR_MatMult_v1_aN1_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aN1_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatMult_v1_aN1_b1_xsX_ysX() */
#define CSR_MatMult_v1_aN1_b1_xsX_ysX \
	MANGLE_(CSR_MatMult_v1_aN1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aN1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatMult_v1_a1_b1_xs1_ysX() */
#define CSR_MatMult_v1_a1_b1_xs1_ysX \
	MANGLE_(CSR_MatMult_v1_a1_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_a1_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatMult_v1_a1_b1_xsX_ysX() */
#define CSR_MatMult_v1_a1_b1_xsX_ysX \
	MANGLE_(CSR_MatMult_v1_a1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_a1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatMult_v1_aX_b1_xs1_ysX() */
#define CSR_MatMult_v1_aX_b1_xs1_ysX \
	MANGLE_(CSR_MatMult_v1_aX_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aX_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatMult_v1_aX_b1_xsX_ysX() */
#define CSR_MatMult_v1_aX_b1_xsX_ysX \
	MANGLE_(CSR_MatMult_v1_aX_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatMult_v1_aX_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatTransMult_v1_aN1_b1_xsX_ys1() */
#define CSR_MatTransMult_v1_aN1_b1_xsX_ys1 \
	MANGLE_(CSR_MatTransMult_v1_aN1_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatTransMult_v1_aN1_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatTransMult_v1_aN1_b1_xsX_ysX() */
#define CSR_MatTransMult_v1_aN1_b1_xsX_ysX \
	MANGLE_(CSR_MatTransMult_v1_aN1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatTransMult_v1_aN1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatTransMult_v1_a1_b1_xsX_ys1() */
#define CSR_MatTransMult_v1_a1_b1_xsX_ys1 \
	MANGLE_(CSR_MatTransMult_v1_a1_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatTransMult_v1_a1_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatTransMult_v1_a1_b1_xsX_ysX() */
#define CSR_MatTransMult_v1_a1_b1_xsX_ysX \
	MANGLE_(CSR_MatTransMult_v1_a1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatTransMult_v1_a1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatTransMult_v1_aX_b1_xsX_ys1() */
#define CSR_MatTransMult_v1_aX_b1_xsX_ys1 \
	MANGLE_(CSR_MatTransMult_v1_aX_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatTransMult_v1_aX_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatTransMult_v1_aX_b1_xsX_ysX() */
#define CSR_MatTransMult_v1_aX_b1_xsX_ysX \
	MANGLE_(CSR_MatTransMult_v1_aX_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^T\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatTransMult_v1_aX_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatHermMult_v1_aN1_b1_xsX_ys1() */
#define CSR_MatHermMult_v1_aN1_b1_xsX_ys1 \
	MANGLE_(CSR_MatHermMult_v1_aN1_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^H\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatHermMult_v1_aN1_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatHermMult_v1_aN1_b1_xsX_ysX() */
#define CSR_MatHermMult_v1_aN1_b1_xsX_ysX \
	MANGLE_(CSR_MatHermMult_v1_aN1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^H\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatHermMult_v1_aN1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatHermMult_v1_a1_b1_xsX_ys1() */
#define CSR_MatHermMult_v1_a1_b1_xsX_ys1 \
	MANGLE_(CSR_MatHermMult_v1_a1_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^H\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatHermMult_v1_a1_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatHermMult_v1_a1_b1_xsX_ysX() */
#define CSR_MatHermMult_v1_a1_b1_xsX_ysX \
	MANGLE_(CSR_MatHermMult_v1_a1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^H\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatHermMult_v1_a1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatHermMult_v1_aX_b1_xsX_ys1() */
#define CSR_MatHermMult_v1_aX_b1_xsX_ys1 \
	MANGLE_(CSR_MatHermMult_v1_aX_b1_xsX_ys1)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^H\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is unit-stride accessible.
 */
extern void CSR_MatHermMult_v1_aX_b1_xsX_ys1(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y  );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatHermMult_v1_aX_b1_xsX_ysX() */
#define CSR_MatHermMult_v1_aX_b1_xsX_ysX \
	MANGLE_(CSR_MatHermMult_v1_aX_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = A^H\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatHermMult_v1_aX_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatConjMult_v1_aN1_b1_xs1_ysX() */
#define CSR_MatConjMult_v1_aN1_b1_xs1_ysX \
	MANGLE_(CSR_MatConjMult_v1_aN1_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = \bar{A}\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatConjMult_v1_aN1_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatConjMult_v1_aN1_b1_xsX_ysX() */
#define CSR_MatConjMult_v1_aN1_b1_xsX_ysX \
	MANGLE_(CSR_MatConjMult_v1_aN1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = \bar{A}\f$,
 *  \f$\alpha=-1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatConjMult_v1_aN1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatConjMult_v1_a1_b1_xs1_ysX() */
#define CSR_MatConjMult_v1_a1_b1_xs1_ysX \
	MANGLE_(CSR_MatConjMult_v1_a1_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = \bar{A}\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatConjMult_v1_a1_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatConjMult_v1_a1_b1_xsX_ysX() */
#define CSR_MatConjMult_v1_a1_b1_xsX_ysX \
	MANGLE_(CSR_MatConjMult_v1_a1_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = \bar{A}\f$,
 *  \f$\alpha=1\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatConjMult_v1_a1_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatConjMult_v1_aX_b1_xs1_ysX() */
#define CSR_MatConjMult_v1_aX_b1_xs1_ysX \
	MANGLE_(CSR_MatConjMult_v1_aX_b1_xs1_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = \bar{A}\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is unit-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatConjMult_v1_aX_b1_xs1_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x ,
	oski_value_t* restrict y , oski_index_t ystride );



#if defined(DO_NAME_MANGLING) && IS_VAL_COMPLEX
/** Mangled name for CSR_MatConjMult_v1_aX_b1_xsX_ysX() */
#define CSR_MatConjMult_v1_aX_b1_xsX_ysX \
	MANGLE_(CSR_MatConjMult_v1_aX_b1_xsX_ysX)
#endif

/**
 *  \brief Computes the SpMV operation
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is complex-valued, \f$\mathrm{op}(A) = \bar{A}\f$,
 *  \f$\alpha=\mbox{general value}\f$, \f$x\f$ is general-stride accessible,
 *  and \f$y\f$ is general-stride accessible.
 */
extern void CSR_MatConjMult_v1_aX_b1_xsX_ysX(
	oski_index_t A_M, oski_index_t A_N,
	const oski_index_t* restrict A_ptr, const oski_index_t* restrict A_ind,
	const oski_value_t* restrict A_val
	, oski_value_t alpha, const oski_value_t* restrict x , oski_index_t xstride,
	oski_value_t* restrict y , oski_index_t ystride );




#endif
/* eof */

