#
# Copyright (C) 2005-2024 Centre National d'Etudes Spatiales (CNES)
#
# This file is part of Orfeo Toolbox
#
#     https://www.orfeo-toolbox.org/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

INCLUDE_ONCE_MACRO(GSL)

SETUP_SUPERBUILD(GSL)

ExternalProject_Add(GSL
  PREFIX GSL
  URL "https://github.com/ampl/gsl/archive/v2.7.0.tar.gz"
  DOWNLOAD_NAME gsl_v2.7.0.tar.gz
  URL_MD5 566ca5f5f08057aa6572aecf7fd67eb9
  BINARY_DIR ${GSL_SB_BUILD_DIR}
  INSTALL_DIR ${SB_INSTALL_PREFIX}
  DOWNLOAD_DIR ${DOWNLOAD_LOCATION}
  CMAKE_CACHE_ARGS ${SB_CMAKE_CACHE_ARGS}
  -DNO_AMPL_BINDINGS:BOOL=ON
  CMAKE_COMMAND ${SB_CMAKE_COMMAND}
  DEPENDS ${GSL_DEPENDENCIES}
  LOG_DOWNLOAD 1
  LOG_CONFIGURE 1
  LOG_BUILD 1
  LOG_INSTALL 1
  )

SUPERBUILD_UPDATE_CMAKE_VARIABLES(GSL FALSE)
