/*=========================================================================

  Program:   ORFEO Toolbox
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


  Copyright (c) Centre National d'Etudes Spatiales. All rights reserved.
  See OTBCopyright.txt for details.


     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#include <cstdlib>
#include <ctime>
#include <fstream>
#include <string>
#include <iostream>
#include <vector>

/**
 * @brief main application for generating the otb.conf file.
 *
 * @param argv[1] Path to OTB_BINARY_DIR/otb.conf
 *
 * @param argv[2] language parameter
 */
int main(int argc, char* argv[])
{
   const unsigned int nbParameters = 2;

   std::ofstream os(argv[1]); 
   if (!os)
   {
      exit(1);
   }

   std::vector <std::string>  paramVector;
   
   /** write available parameters to a vector */
   for (unsigned int i=0;i<nbParameters;++i)
   {
     if ( argc >= static_cast<int>( i+3 ) )
     {
       /** Get the default parameter (from cmake)*/
       paramVector.push_back( argv[i+2] );
     }
     else
     {
       /** Set param="" if the parameter is not available*/
       paramVector.push_back("");
     }
   }
   
   /** Get local configuration*/
//    const std::locale& mylocale = std::locale("");
//    std::string language = mylocale.name();
   
//    if (language == "C")
   std::string language = "en_EN.UTF-8";
   
   /** Write parameters to the configuration file*/
   os << "# Auto generated by config-properties \n\n"
      << "# Language for the GUI application based on otb\n"
      << "# for example OTB_LANG=en_EN.UTF-8\n"
      << "OTB_LANG="
      <<  language
      << "\n\n"
      << "# Image size (in byte) to activate the streaming\n"
      << "OTB_STREAM_IMAGE_SIZE_TO_ACTIVATE_STREAMING="
      <<  paramVector[0]
      << "\n\n"
      << "# Buffer size when the streaming is activated\n"
      << "OTB_STREAM_MAX_SIZE_BUFFER_FOR_STREAMING="
      <<  paramVector[1]
      << "\n\n"
      << "#End of config file properties generation\n"
      << std::endl;
   
   os.close();
   
   std::cout << "wrote file: " << argv[1] << std::endl;

   exit(0);
}
