**Release Process for OpenVDB**

The following assumes that the current OpenVDB library version number is 6.0.0 and the new version number is 6.1.0. Adjust for the actual version numbers as appropriate.

- [ ] Open a Jira "Release OpenVDB 6.1.0" ticket with "OpenVDB_6.1.0" as the Fix Version.
- [ ] Update `CHANGES` and `doc/changes.txt` with release notes. Ensure doc/doxygen-config has the correct release number.  [_Specifics TBD, pending a review of release note management tools._]
- [ ] Open a pull request to merge the above changes into `openvdb/master`.  Associate the pull request with the Jira ticket created earlier, and verify that the CI build runs successfully.
- [ ] Draft a new [GitHub release](https://github.com/AcademySoftwareFoundation/openvdb/releases). Title it "OpenVDB 6.1.0" and tag it as `v6.1.0`.

- [ ] Update `openvdb-website/index.html` with a news item announcing the release, and delete the oldest news item.  Open that page in a browser and check that the website renders correctly and that there are no broken links.
- [ ] Build the documentation (for the core library and python module) using Doxygen 1.8.11 and replace the contents of `openvdb-website/documentation/doxygen/` with the output. There are two sub folders, /search and /python. /search will be generated by the core doxygen commands. The /python folder will be built by epydoc. The python documentation requires the python module to be built and installed. Make sure you build with OPENVDB_PYTHON_WRAP_ALL_GRID_TYPES=ON, otherwise documentation will not be generated for some grid types. An example CMake command list (assuming within a nested build folder):

```shell
# Build python module and core documentation
install_location_on_path=/usr/local
website_dox_location=openvdb-website/documentation/doxygen/
cmake ../ \
    -DCMAKE_INSTALL_PREFIX=$install_location_on_path \
    -DOPENVDB_BUILD_PYTHON_MODULE=ON \
    -DOPENVDB_PYTHON_WRAP_ALL_GRID_TYPES=ON \
    -DOPENVDB_BUILD_BINARIES=OFF \
    -DOPENVDB_BUILD_DOCS=ON \
    && make install
# remove existing doxygen
rm $website_dox_location/* && rm $website_dox_location/search/*
# move new doxygen
cp -r $install_location_on_path/share/doc/OpenVDB/html/* $website_dox_location/
# commit doxygen changes
git commit -s -m "<TICKET-NUMBER> Doxygen updates"
# generate python documentaion - make sure this pick up your newly installed module
epydoc --html -o python pyopenvdb
# remove existing python docs
rm $website_dox_location/python/*
# move python documentation
cp -r python/* $website_dox_location/python/
# commit pydoc changes
git commit -s -m "<TICKET-NUMBER> Python doc updates"
```

[_This step should be automated, and the thousands of files it generates should preferably not be committed to the repository._]

- [ ] Open a pull request to merge the above changes into `openvdb-website/master`.  Associate the pull request with the Jira ticket created earlier.
- [ ] Publish the GitHub draft release.
- [ ] Post a release announcement to the [OpenVDB forum](https://groups.google.com/forum/#!forum/openvdb-forum).

- [ ] In preparation for the next release, change one or more of `OPENVDB_LIBRARY_PATCH_VERSION_NUMBER`, `OPENVDB_LIBRARY_MINOR_VERSION_NUMBER` and `OPENVDB_LIBRARY_MAJOR_VERSION_NUMBER` in `openvdb/version.h`.  Unless it is known that the next release will include API- or ABI-breaking changes, increment only the patch number to begin with (in this case, from 6.1.0 to 6.1.1).  In `doc/doxygen-config` update `PROJECT_NUMBER`, `OPENVDB_VERSION_NAME`, `OPENVDB_ABI_VERSION_NUMBER` and the `@vdbnamespace` alias to match `version.h`, and add a "Version 6.1.1 - In development" section to `CHANGES` and to `doc/changes.txt`.  Open a pull request to merge these changes into `openvdb/master`.
- [ ] Add an "OpenVDB_6.1.1" version to Jira.

END

