# Overview

This project aims to be governed in a transparent, accessible way for the benefit of the community. All participation in this project is open and not bound to corporate affilation. Participants all our bound to the ASWF Code of Conduct.

# Project roles

## Contributor

The contributor role is the starting role for anyone participating in the project and wishing to contribute code.

# Process for becoming a contributor

* Review the [coding standards](http://www.openvdb.org/documentation/doxygen/codingStyle.html) to ensure your contribution is in line with the project's coding and styling guidelines.
* Sign the Individual CLA and have your organization sign the Corporate CLA.
* Submit your code as a PR with the appropriate DCO sign-off.
* Have your submission approved by the maintainer(s) and merged into the codebase.

## Committer

The committer role enables the participant to commit code directly to the repository, but also comes with the obligation to be a responsible leader in the community.

### Process for becoming a committer

* Show your experience with the codebase through contributions and engagement on the community channels.
* Request to become a committer.
* Have the majority of committers approve you becoming a committer.
* Your name and email is added to the MAINTAINERS.md file for the project.

### Committer responsibilities

* Monitor email aliases.
* Monitor Slack (delayed response is perfectly acceptable).
* Triage GitHub issues and perform pull request reviews for other committers and the community.
* Make sure that ongoing PRs are moving forward at the right pace or close them.
* In general continue to be willing to spend at least 25% of one's time working on the project (~1.25 business days per week).

### When does a committer lose committer status?

If a committer is no longer interested or cannot perform the committer duties listed above, they
should volunteer to be moved to emeritus status. In extreme cases this can also occur by a vote of
the committers per the voting process below.

## Technical Steering Committee (TSC) member

The Technical Steering Committee (TSC) oversees the overall technical direction of OpenVDB, as defined in the [charter](charter.md).

TSC voting members consist of committers that have been nominated by the committers, with a supermajority of voting members required to have a committer elected to be a TSC voting member. TSC voting members term and succession is defined in the [charter](charter.md).

All meetings of the TSC are open to participation by any member of the OpenVDB community. Meeting times are listed in the [ASWF technical community calendar](https://lists.aswf.io/g/tac/calendar).

## Current TSC members

* Ken Museth, Chair / Weta
* Peter Cucka, DreamWorks
* Jeff Lait, SideFX
* Nick Avramoussis, Double Negative
* Dan Bailey, ILM

# Release Process

Project releases will occur on a scheduled basis as agreed to by the TSC.

# Conflict resolution and voting

In general, we prefer that technical issues and maintainer membership are amicably worked out
between the persons involved. If a dispute cannot be decided independently, the TSC can be
called in to decide an issue. If the TSC themselves cannot decide an issue, the issue will
be resolved by voting. The voting process is a simple majority in which each TSC receives one vote.

# Communication

This project, just like all of open source, is a global community. In addition to the Code of Conduct, this project will:

* Keep all communication on open channels ( mailing list, forums, chat ).
* Be respectful of time and language differences between community members ( such as scheduling meetings, email/issue responsiveness, etc ).
* Ensure tools are able to be used by community members regardless of their region.

If you have concerns about communication challenges for this project, please contact the maintainers.
