Minutes from 19th OpenVDB TSC meeting, June 6, 2019

Attendees: *Ken* M., *Nick* A., *Dan* B., *Peter* C., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel)

Agenda:

1) Quorum Secretary
2) Secretary Selection
3) CI Update
4) Plans for 6.2
Non-Planned A) Rasterization
Non-Planned B) Response to Autodesk
5) TestUtil::testPagedArray
6) OpHiding Next Steps
Non-Planned C) Retrospective
7) Delayed Load Update
8) Version/Namespacing SOPs
9) Speed of hasActiveTiles/voxelizeActiveTiles
10) GCC and Dual ABI
11) Memory Allocators
12) Topology Replace
13) Schedule Next Meeting

1) A quorum was confirmed

2) Secretary - Dan Bailey

3) CI Update

The ASWF is likely going to be selecting Azure Pipelines as their favored CI
service so we are investigating moving to this. Azure Pipelines has been enabled
as a GitHub Check and Dan has submitted a PR to switch on everything that
currently builds in Circle. This works a little differently in Azure than
Circle, because it uses Docker containers to store pre-installed dependencies to
accelerate the startup time and avoid re-installing all our dependencies from
scratch.

The next step is to consolidate the Houdini installations into a single docker
container and to make this docker repository private, as we cannot distribute
releases of Houdini in a public repository, because it requires signing a EULA.
DockerHub individuals have access to one private repository, whereas DockerHub
organizations have none so without paying a regular monthly subscription, the
Houdini repository will need to live under Dan's account for the time being.
Longer term, the intention is to build using DockerHub images published through
the ASWF, though that's not included as part of this initial migration.

4) Plans for 6.2

No precise date is present at the moment. Siggraph is still a tentative date.
Integration with Houdini++ likely requires a release around that date. Peter
reminds the committee that we shouldn't feel under pressure to do this release.
We should hold off if the release isn't ready or there are not sufficient
changes for it to be worthwhile.

In turn each committee member listed what they would like to contribute to 6.2.

Peter is looking to include a new sharpening tool and SOP. PR has been
submitted, awaiting feedback from Ken. Jeff was asked about how to best display
kernel coefficients in Houdini's UI and replied that SideFX hadn't found an
ideal solution to this problem.

Ken will release a fix to PagedArray later today. Planning to submit
multi-threaded conversion to spheres and velocity extension among a few other
tools. He would like to include read-only grid data structure developed at Weta,
but thinks it's unlikely to be possible by 6.2. This may be of particular
interest to the rendering community.

Nick believes surfacing is not feasible in the likely timeframe and is primarily
focused on AX. Initial aim is to include AX on a feature branch that is part of
the main repository by 6.2. Nick to ask John Mertic about setting up a private
repo for the committee to share features that cannot yet be made public.

Dan would primarily like to include delayed-loading improvements and VDB SOP
unification, both of are submitted as PRs and under active discussion. A
secondary goal is to extend the move points API to add merge capability and
introduce this functionality to VDB SOPs. Nick to share DNeg's production-proven
implementation of merging VDB Points grids to help with this effort.

Non-Planned A) Rasterization

It was widely acknowledged that rasterization is a hard problem and has many
differing requirements resulting in a highly divergent solution space. Jeff gave
a brief overview of some of the key considerations and a little history about
the various different rasterization tools that Houdini ships with. The TSC
members are in agreement that we would like to better solve this problem and it
was suggested that Siggraph might provide a good opportunity to discuss this
area in more detail.

Non-Planned B) Response to Autodesk

Ken is working on a response to Autodesk and will share a Google Doc with the
TSC members shortly.

5) TestUtil::testPagedArray

Ken has completed a fix, planning to submit shortly.

6) OpHiding Next Steps

An in-depth discussion about this feature was held. The TSC members are
currently unable to find consensus on the right approach to take here. However,
agreement was found in a number of areas. The TSC remains motivated to resolve
the underlying problem where duplicate OpenVDB and VDB SOPs show up in the tab
menus as this behavior has caused confusion to artists for many years.

There was agreement on the need to provide a link between the open-source SOPs
and the native SOPs shipped with Houdini. It was felt that this would be best
done in C++ by extending the existing policies and the operator registration.

There was no objection to including a startup script in some form. There was
agreement that using HScript/OPcustomize was well-suited for simple startup
scripts that hide nodes and Jeff confirmed that there was no plans to deprecate
HScript. Where any conditional logic were to be included, it was felt that using
a pythonrc script would be a better fit.

There was a desire to try and provide just one solution to this problem. This
was mainly motivated from not wanting to cause undue confusion to artists and
developers.

It was also agreed that the configurability of the new policy/flags mechanism
implemented by Dan in C++ was overkill given that a startup script would be
offered. Dan will remove this functionality from the PR.

The TSC was largely in agreement that an environment variable was an acceptable
mechanism to provide to artists to adjust the hiding policy.

The main area of contention was whether to make a startup script the only way to
adjust hiding of nodes or whether to also allow this to be configured from C++.
Dan and Jeff felt that adding an OPcustomize/pythonrc file added an additional
point of failure and that it required users to correctly install OpenVDB which
shouldn't be taken for granted. Peter and Nick felt that using
OPcustomize/pythonrc was the correct way to solve this problem and that VDB
should instead follow precedence and advice offered by SideFX in using that
mechanism. To make use of this feature, users would be expected to install this
additional file.

Jeff highlighted an additional problem in how the ASWF label suffix should be
added if two different mechanisms for controlling visibility are in use. Peter
suggested using an oprename in the start script to solve this there.

The next steps are for Dan to re-visit the current implementation and attempt to
find some common ground. Peter will look at implementing an alternative solution
using pythonrc as a prototype for discussion in the meeting next week or the
week after.

Non-Planned C) Retrospective

The TSC acknowledged that the process of resolving the OpHiding problem wasn't
very effective and has resulted in some back-and-forth. Dan and Jeff
collaborated on a proposal that didn't receive any feedback at the time. There
was an assumption that lack of feedback meant no significant objection to the
proposal. Dan put together an initial implementation which has been subsequently
changed multiple times and Peter has spent quite a lot of time reviewing. One
suggestion was to present this proposal to the TSC members in an earlier
meeting, which may have helped elevate some of this discussion earlier. Peter
cautioned that sometimes the discussion can only be had once there is an
implementation to look at.

Ken raised an additional concern - in the past features used to be vetted
internally at Dreamworks, proven in production first and then released publicly.
With a cross-company collaboration now in-place, much of that vetting is now
happening before a feature has been production-proven. This may give the TSC
less confidence in including it in OpenVDB.

8-12) Time

13) Schedule Next Meeting

June 13th 2019.  3pm-4pm EDT (GMT-4).
