#
# Script Written By Ferdy Riphagen
# <f(dot)riphagen(at)nsec(dot)nl>
#
# This script is released under the GNU GPLv2
#

if (description) {
script_id(200003);
script_version("$Revision: 1.0 $");

script_bugtraq_id(15078);

name["english"] = "Zeroblog <= 1.2a Cross-Site Scripting Vulnerability";
script_name(english:name["english"]);

desc["english"] = "
Synopsis :

The remote host contains a PHP script that is vulnerable to cross-site
scripting attacks.

Description :

The remote host appears to be running ZeroBlog.

A vulnerability was identified in Zeroblog, which may be exploited by
remote attackers to inject script code.

ZeroBlog does not properly sanitize user input in the 'threadID', 'replyID' and 'albumID' parameters.

Solution :

Unknown at this time.

Risk factor :

Low";
script_description(english:desc["english"]);

summary["english"] = "Check if Zeroblog is vulnerable to cross-site scripting attacks.";
script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);
script_family(english:"CGI abuses : XSS");

script_copyright(english:"This script is Copyright (C) 2005 Ferdy Riphagen");

script_dependencie("http_version.nasl");
script_require_ports("Services/www", 80);

exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
include("url_func.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);
if (get_kb_item(string("www/", port, "/generic_xss"))) exit(0);

xss = "'<IFRAME SRC=javascript:alert(%27XSS DETECTED BY NESSUS%27)></IFRAME>";
exss = urlencode(str:xss);

if (thorough_tests) dirs = make_list("/zeroblog", "/", "/blog", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
 res = http_get_cache(item:string(dir, "/thread.php"), port:port);
 if (res == NULL) exit(0);

 if (egrep(pattern:">.*Copyright.*(C).*ZeroCom.*computers", string:res))
 {
  req = http_get(item:string(dir, "/thread.php?threadID=", exss), port:port);

  recv = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
  if(recv == NULL)exit(0);

  if(xss >< recv)
  {
   security_note(port);
   exit(0);
  }
 }
}
