# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-740-1 (firefox)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63624);
 script_cve_id("CVE-2004-2761");
 script_version ("$");
 name["english"] = "Ubuntu USN-740-1 (firefox)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to firefox
announced via advisory USN-740-1.

Details follow:

The MD5 algorithm is known not to be collision resistant. This update
blacklists the proof of concept rogue certificate authority as discussed
in http://www.win.tue.nl/hashclash/rogue-ca/.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libnss3                         1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2

Ubuntu 7.10:
  libnss3-0d                      3.11.5-3ubuntu0.7.10.2

Ubuntu 8.04 LTS:
  libnss3-0d                      3.12.0.3-0ubuntu0.8.04.5
  libnss3-1d                      3.12.0.3-0ubuntu0.8.04.5

Ubuntu 8.10:
  libnss3-1d                      3.12.0.3-0ubuntu5.8.10.1

After a standard system upgrade you need to restart your session to
effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-740-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-740-1 (firefox)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dbg", ver:"1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"1.5.dfsg+1.5.0.15~prepatch080614k-0ubuntu2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d-dbg", ver:"3.11.5-3ubuntu0.7.10.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d", ver:"3.11.5-3ubuntu0.7.10.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-dev", ver:"3.11.5-3ubuntu0.7.10.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-tools", ver:"3.11.5-3ubuntu0.7.10.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d", ver:"3.12.0.3-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-1d-dbg", ver:"3.12.0.3-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-1d", ver:"3.12.0.3-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-dev", ver:"3.12.0.3-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-tools", ver:"3.12.0.3-0ubuntu0.8.04.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-1d-dbg", ver:"3.12.0.3-0ubuntu5.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-1d", ver:"3.12.0.3-0ubuntu5.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-dev", ver:"3.12.0.3-0ubuntu5.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d", ver:"3.12.0.3-0ubuntu5.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-tools", ver:"3.12.0.3-0ubuntu5.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
