#
#
# Copyright 2005 DN Systems GmbH
#
# License: GNU GPLv2 or any later version
#

debug = 0;

include ("ssh_func.inc");
include ("slad.inc");
include ("slad_ssh.inc");

if(description) {
  script_id(90003);
  script_version ("1.0");
  name["english"] = "SLAD Fetch Results";
  
  script_name(english:name["english"]);
  
  desc["english"] = "
This script connects to SLAD on a remote host to fetch 
the result from scripts started earlier.
To work properly, this script requires to be provided
with a valid SSH login by means of an SSH key with pass-
phrase if the SSH public key is passphrase-protected, or
a password to log in.";

  script_description(english:desc["english"]);
  
  summary["english"] = "Connects to SLAD to fetch installed plugins";
  script_summary(english:summary["english"]);
  
  script_category(ACT_GATHER_INFO);
  
  script_copyright(english:"This script is Copyright 2005 DN Systems GmbH");
  family["english"] = "SLAD";
  script_family(english:family["english"]);
  
  script_dependencies ("find_service.nes", "slad_init.nasl");
  script_require_ports (22, "Services/ssh");
  script_require_keys ("SLAD/login");

  exit(0);
}

{
  sock = slad_ssh_login ();
  
  slad_exe = '/opt/slad/bin/sladd';
  slad_cmd = slad_exe + ' -s jobs';

  report = ssh_cmd (socket:sock, cmd:slad_cmd, timeout:60);
  if (debug) display (report);

  bhead = report;
  while (bhead) {
    eol = strstr (bhead, string ("\n"));
    line = substr (bhead, 0, strlen (bhead) - strlen (eol) -1);
    bhead = substr (bhead, strlen (line) + 1);
    parts = split (line, sep: ':', keep: FALSE);
    job = parts[1] + ":" + parts[2] + ":" + parts[3];
    desc = get_slad_description (entry: job);

    if (debug) display ("line:", line, "Part0: ", parts[0], " job: ", job, " desc: ", desc, string ("\n"));

    if (parts[0] == "R") {
      running += string (desc + "\n");
    } else if (parts[0] == "T") {
      results += string (desc + "\n");
      slad_cmd = slad_exe + ' -s ' + job;
      results += ssh_cmd (socket:sock, cmd:slad_cmd, timeout:60);
      results += string ("\n");
    }
  }
  if (results) security_warning (data: results);
  if (running) security_warning (data: string ("Still running processes: \n" + running));
  close (sock);
}
