##############################################################################
#
#  XM Easy Personal FTP Server 'NSLT' Command Remote DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/17
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0349
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900158);
  script_bugtraq_id(31739);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_name(english:"XM Easy Personal FTP Server 'NSLT' Command Remote DoS Vulnerability");
  script_summary(english:"Check for vulnerable version of XM Easy Personal FTP Server");
  desc["english"] = "
  Overview: The host is running XM Easy Personal FTP Server, which is prone to
  denial of service vulnerability. 

  The vulnerability is due to an error when handling a malformed NLST command.

  Impact:
  Successful exploitation will cause denial of service to legitimate users.

  Impact Level: Application

  Affected Software/OS:
  dxmsoft XM Easy Personal FTP Server version 5.6.0 and prior on Windows (all)

  Fix: No solution/patch is available as on 17th October, 2008.

  References:
  http://www.dxm2008.com/
  http://www.milw0rm.com/exploits/6741

  CVSS Score:
    CVSS Base Score     : 6.3 (AV:N/AC:M/Au:SI/C:N/I:N/A:C)
    CVSS Temporal Score : 5.7
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencie("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if("DXM's FTP Server" >!< banner){
  exit(0);
}

if(egrep(pattern:"DXM's FTP Server 5\.([0-5](\..*)?|6\.0)($|[^.0-9])",
         string:banner))
{
  security_warning(port);
  exit(0);
}
