##############################################################################
#
#  RhinoSoft Serv-U SFTP Remote Denial of Service Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/20
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0133
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900113);
 script_bugtraq_id(30739);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"RhinoSoft Serv-U SFTP Remote Denial of Service Vulnerability");
 script_summary(english:"Check for vulnerable version and prior of Serv-U");
 desc["english"] = "
 Overview: The host is running RhinoSoft Serv-U SFTP, which is prone to denial
 of service vulnerability.

 Vulnerability Insight :

        The flaw is caused due to an error within the logging functionality, when
        creating directories via SFTP or when handling certain SFTP commands.

        Impact: Remote exploitation will allow attackers to cause the server crash
        or denying the service.

 Impact Level : Application

 Affected Software/OS :
        RhinoSoft Serv-U versions prior to 7.2.0.1 on Windows (All).
 
 Fix: Update to version 7.2.0.1.
 http://www.serv-u.com/dn.asp

 References:
 http://www.serv-u.com/releasenotes/
 http://secunia.com/advisories/31461/

 CVSS Score:
        CVSS Base Score     : 6.3 (AV:N/AC:M/Au:SI/C:N/I:N/A:C)
        CVSS Temporal Score : 4.7 
 Risk factor: Medium"; 

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl", "find_service.nes");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");
 include("ftp_func.inc");
 include("secpod_smb_func.inc");

 ftpPort = get_kb_item("Services/ftp");
 if(!ftpPort){
	ftpPort = 21;
 }

 if(!get_port_state(ftpPort)){
	exit(0);
 }

 if("Serv-U" >!< get_ftp_banner(port:ftpPort)){
	exit(0);
 }

 if (!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }
 
 servPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
				"\App Paths\Serv-U", item:"Path");
 if(!servPath){
        exit(0);
 }

 share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:servPath);
 file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",string:servPath + "\Serv-U.exe");

 name = kb_smb_name();
 domain = kb_smb_domain();
 login = kb_smb_login();
 pass = kb_smb_password();
 port = kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
	close(soc);
        exit(0);
 }
 
 prot = smb_neg_prot(soc:soc);
 if(!prot){
	close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r){
	close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

 tid = tconx_extract_tid(reply:r);
 if(!tid){
	close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
	close(soc);
        exit(0);
 }

 ftpVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod");
 close(soc);

 if(!ftpVer){
	exit(0);
 } 

 if(egrep(pattern:"^([0-6]\..*|7\.([01](\..*)?|2(\.0(\.1)?)?))$", string:ftpVer)){
	security_warning(ftpPort);
 }
