###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_raidenftpd_server_detect.nasl 1046 2009-02-25 15:21:24Z feb $
#
# RaidenFTPD Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900510);
  script_version("$Revision: 1.0 $");
  script_name(english:"RaidenFTPD Server Version Detection");
  desc["english"] = "

  Overview: This script finds the installed version of RaidenFTPD Server
  and sets the result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the version of RaidenFTPD Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"FTP");
  script_dependencies("find_service.nes", "secpod_reg_enum.nasl");
  script_require_ports("Services/ftp", 21);
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("ftp_func.inc");
include("secpod_smb_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)){
  exit(0);
}

if("RaidenFTPD" >!< get_ftp_banner(port:ftpPort)){
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

exePath = registry_get_sz(key:"SYSTEM\CurrentControlSet\Services" +
                              "\RaidenFTPDService", item:"ImagePath");
if(!exePath){
  exit(0);
}

exePath = exePath - "rftpdservice.exe" + "raidenftpd.exe";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

rftpdVer = GetVer(file:file, share:share);
if(rftpdVer != NULL){
  set_kb_item(name:"RaidenFTPD/Ver", value:rftpdVer);
}
