###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opensc_insecure_key_generation_vuln.nasl 2248 2009-05-19 20:37:34Z may $
#
# OpenSC Incorrect RSA Keys Generation Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900639);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1603");
  script_bugtraq_id(34884);
  script_name(english:"OpenSC Incorrect RSA Keys Generation Vulnerability");
  desc["english"] = "

  Overview: This host is installed with OpenSC and is prone to Insecure Key
  Generation vulnerability.

  Vulnerability Insight:
  Security issue are caused due to,
  - a tool that starts a key generation with public exponent set to 1, an
    invalid value that causes an insecure RSA key.
  - a PKCS#11 module that accepts that this public exponent and forwards it
    to the card.
  - a card that accepts the public exponent and generates the rsa key.

  Impact:
  Successful exploitation will let the attacker to obtain the sensitive
  information or gain unauthorized access to the smartcard.

  Impact Level: Application

  Affected Software/OS:
  OpenSC version prior to 0.11.8 on Linux.

  Fix:
  Upgrade to OpenSC version 0.11.8
  http://www.opensc-project.org/files/opensc

  References:
  http://secunia.com/advisories/35035
  http://www.vupen.com/english/advisories/2009/1295
  http://www.opensc-project.org/pipermail/opensc-announce/2009-May/000025.html

  CVSS Score:
   CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
   CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of OpenSC");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPOd");
  script_family(english:"Privilege escalation");
  script_dependencies("gb_opensc_detect.nasl");
  script_require_keys("OpenSC/Ver");
  exit(0);
}


include("version_func.inc");

openscVer = get_kb_item("OpenSC/Ver");
if(openscVer != NULL)
{
  # Check for the version OpenSC < 0.11.8
  if(version_is_less(version:openscVer, test_version:"0.11.8")){
    security_warning(0);
  }
}
