##############################################################################
#
#  Novell iPrint Client ActiveX Control Multiple Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/26
#
#  Revision: 1.2 
#
#  Log: schandan
#  Issue #0141
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900040);
 script_bugtraq_id(30813);
 script_cve_id("CVE-2008-2431",	"CVE-2008-2432");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"Novell iPrint Client ActiveX Control Multiple Vulnerabilities");
 script_summary(english:"Check for the vulnerable version of Novell iPrint");
 desc["english"] = "
 Overview : This host has Novell iPrint Client installed, which is prone
 to activex control vulnerabilities.

 Vulnerability Insight :

        The flaws are due to,
        - boundary errors in ienipp.ocx file when processing GetDriverFile(),
          GetFileList(), ExecuteRequest(), UploadPrinterDriver(),
          UploadResource(), UploadResource(), UploadResourceToRMS(),
          GetServerVersion(), GetResourceList(), or DeleteResource() methods.
        - a boundary error in nipplib.dll when processing IppGetDriverSettings()
          while creating a server reference or interpreting a URI.
        - an error in the GetFileList() method returns a list of images
          (eg., .jpg, .jpeg, .gif, and .bmp) in a directory specified as
          argument to the method.

        Impact : Remote exploitation could allow execution of arbitrary code to
        cause the server to crash or denying the access to legitimate users.

 Impact Level : Application

 Affected Software/OS :
        Novell iPrint Client version 4.36 and prior on Windows (All).

 Affected Platform : Windows (Any).

 Fix : No solution/patch is available as on 26th August, 2008. Information
 regarding this issue will updated once the solution details are available.
 For updates refer, http://download.novell.com/index.jsp

 References : http://www.frsirt.com/english/advisories/2008/2429

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.8
 Risk factor : Medium";
 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 iPrintVer = registry_get_sz(key:"SOFTWARE\Novell-iPrint",
			     item:"Current Version");
 if(!iPrintVer){
	exit(0);
 }

 if(ereg(pattern:"^v0?([0-3]\..*|4\.([0-2][0-9]|3[0-6])\.00)$",
	 string:iPrintVer)){
	 security_warning(0);
 }
