##############################################################################
#
#  Microsoft Windows RTCP Unspecified Remote DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/26
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0500
#
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program. 
##############################################################################

if(description)
{
  script_id(900404);
  script_bugtraq_id(32341);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_name(english:"Microsoft Windows RTCP Unspecified Remote DoS Vulnerability");
  script_summary(english:"Check for vulnerable version of Live Messenger");
  desc["english"] = "
  Overview: This host is installed with Microsoft Live Messenger and is prone to 
  remote Denial of Service vulnerability. 
  
  Vulnerability Insight:
  The vulnerability is caused due to error in the 'RTCP' or
  'Real-time Transport Control Protocol' receiver report packet handling.

  Impact:
  Successful exploitation will crash the application.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Windows Live Messenger version 8.5.1302.1018 and prior.
  
  Fix: No solution/patch is available as on 26th November, 2008.
  
  References:
  http://www.voipshield.com/research-details.php?id=132

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
entries = registry_enum_keys(key:key);
foreach item (entries)
{
  if("Windows Live Messenger" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    # Grep or versions Windows Live Messenger version 8.5.1302.1018 and prior.
    if((egrep(pattern:"^([0-7]\..*|8\.[0-4](\..*)?|8\.5(\.([0-9]?[0-9]?[0-9]" +
                      "|1[0-2]?[0-9]?[0-9]?|130[01])(\..*)?|\.1302)?(\.[0-9]" +
                      "?[0-9]?[0-9]|\.100[0-9]|\.101[0-8])?)?$",
              string:registry_get_sz(key:key + item, item:"DisplayVersion")))){
      security_warning(0);
    }
  }
}
