##############################################################################
#
#  Microsoft Organization Chart Remote Code Execution Vulnerability 
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/10
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0178
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900120);
 script_bugtraq_id(31059);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Windows");
 script_name(english:"Microsoft Organization Chart Remote Code Execution Vulnerability");
 script_summary(english:"Check for vulnerable version and prior of Microsoft Organization Chart");
 desc["english"] = "
 Overview : The host has Microsoft Organization Chart, which is prone to a
 remote code execution vulnerability.

 Vulnerability Insight :

        Microsoft Organization Chart is prone to a remote code execution 
        vulnerability. The flaw is caused due to memory access violation 
        error when opening malicious Organization Chart document. 

        Impact : Enticing the victim into opening a malicious crafted
        Organization Chart document, remote attackers can crash the application
        or execute arbitrary code on the affected system within the context
        of the affected application. 

 Impact Level : Application

 Affected Software/OS :
        MS Organization Chart versions 2.0 (11.0.5614.0) and prior on Windows (all).

 Fix : No solution/patch is available as on 10th September, 2008. Information
 regarding this issue will be updated once the solution details are available.
 For updates check, http://office.microsoft.com/en-us/ork2003/HA011402441033.aspx

 References :
 http://www.securityfocus.com/bid/31059/discuss
 http://www.securityfocus.com/bid/31059/exploit
 http://www.nullcode.com.ar/ncs/crash/orgchart.htm

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 7.5
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 name = kb_smb_name();
 domain = kb_smb_domain();
 login = kb_smb_login();
 pass = kb_smb_password();
 port = kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc) ;
 if(!prot){
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                            prot:prot);
 if(!r){
	close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");

 tid = tconx_extract_tid(reply:r);
 if (!tid){
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r){
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe){
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r){
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle){
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 msOrgKey = registry_get_key(soc:soc, uid:uid ,tid:tid ,pipe:pipe,key:key,
                                 reply:handle);
 if(!msOrgKey){
	close(soc);
        exit(0);
 }

 entries = registry_enum_key(soc:soc, uid:uid, tid:tid, pipe:pipe, 
                                 reply:msOrgKey);
 close(soc);

 foreach entry (entries)
 {
        msOrgName = registry_get_sz(key:key + entry, item:"DisplayName");
        
	if("Microsoft Organization Chart 2.0" >< msOrgName)
        {
                msOrgVer = registry_get_sz(key:key + entry, 
                                           item:"DisplayVersion");

		# Grep for version <= 11.0.5614.0
                if(egrep(pattern:"^(([0-9]|10)\..*|11\.0\.([0-4]?[0-9]?[0-9]?[0-9]" +
				 "|5[0-5][0-9][0-9]|560[0-9]|561[0-4])\.0)$",
			 string:msOrgVer)){
			security_warning(0);
                }
                exit(0);
        }
 }
