###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-014.nasl 1694 2009-04-15 10:55:42Z apr $
#
# Microsoft Internet Explorer Remote Code Execution Vulnerability (963027)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900328);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-2540", "CVE-2009-0550", "CVE-2009-0551", "CVE-2009-0552",
                "CVE-2009-0553", "CVE-2009-0554");
  script_bugtraq_id(29445, 34439, 34438, 34423, 34424, 34426);
  script_name(english:"Microsoft Internet Explorer Remote Code Execution Vulnerability (963027)");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-014.

  Vulnerability Insight:
  Flaws are due to
  - Blended threat issue which allows executables to be downloaded in user's
    computer without prompting.
  - Vulnerability in NT LAN Manager which allows the attacker to replay NTLM
    credentials.
  - Arbitrary code execution in Internet Explorer at run time of Internet
    Explorer Browser.
  - Internet Explorer Uninitialized Memory Variant which lets the attacker
    cause remote code execution.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes into
  the context of the affected system and can cause denial of service in the
  affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Internet Explorer version 5.x/6.x/7.x

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-014.mspx

  References:
  http://support.microsoft.com/kb/963027
  http://www.microsoft.com/technet/security/Bulletin/MS09-014.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the vulnerable file version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# MS08-073 Hotfix (958215)
if(hotfix_missing(name:"963027") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");

dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for mshtml.dll version 5 < 5.0.3874.1900
  if(version_in_range(version:vers, test_version:"5.0",
                      test_version2:"5.0.3874.1899")){
    security_hole(0);
  }
  # Check for mshtml.dll version 6 < 6.0.2800.1625
  else if(version_in_range(version:vers, test_version:"6.0",
                           test_version2:"6.0.2800.1624")){
    security_hole(0);
  }
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6 < 6.0.2900.3527
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.2900.3526")){
      security_hole(0);
    }
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for mshtml.dll version 6 < 6.0.2900.5764 or 7.0 < 7.0.6000.16825
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.2900.5763") ||
       version_in_range(version:vers, test_version:"7.0",
                        test_version2:"7.0.6000.16824")){
      security_hole(0);
    }
  }
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Check for mshtml.dll version 6 < 6.0.3790.3304
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.3790.3303")){
      security_hole(0);
    }
  }
  else if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6 < 6.0.3790.4470 or 7.0 < 7.0.6000.16825
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.3790.4469") ||
      version_in_range(version:vers, test_version:"7.0",
                        test_version2:"7.0.6000.16824")){
      security_hole(0);
    }
  }
}
