###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-002.nasl 1007 2009-02-11 09:26:04Z feb $
#
# Cumulative Security Update for Internet Explorer (961260)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900078);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0075", "CVE-2009-0076");
  script_bugtraq_id(33627, 33628);
  script_name(english:"Cumulative Security Update for Internet Explorer (961260)");
  desc["english"] = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-002.

  Vulnerability Insight:
  - An error occurs when IE browser tries to use a previously deleted object
    related to CFunctionPointer.
  - An error exists when XHTML strict mode is used in the zoom style directive
    in conjunction with other directives within the Cascading Style Sheets (CSS)
    stylesheet in a crafted HTML document.

  Impact:
  Successful exploitation could result in memory corruption by executing
  arbitrary code when user visits a specially crafted web page.

  Impact Level: System

  Affected Software/OS:
  Internet Explorer 7/8 on MS Windows 2003 and XP

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-002.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms09-002.mspx

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 5.3
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl", "gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2003:3) <= 0){
  exit(0);
}

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# MS09-002 Hotfix (961260)
if(hotfix_missing(name:"961260") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

# Check for IE version 7.0 < 7.0.6000.16809
if(version_in_range(version:vers, test_version:"7.0",
                    test_version2:"7.0.6000.16808")){
  security_hole(0);
}

# Check for IE version 8.0 < 8.0.6001.18259
else if(version_in_range(version:vers, test_version:"8.0",
                         test_version2:"8.0.6001.18258")){
  security_hole(0);
}
