###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_limesurvey_info_disc_vuln.nasl 2247 2009-05-15 21:18:29Z may $
#
# LimeSurvey Information Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900353);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-1604");
  script_bugtraq_id(34785);
  script_name(english:"LimeSurvey Information Disclosure Vulnerability");
  desc["english"] = "

  Overview: This host is running LimeSurvey and is prone to Information
  Disclosure vulnerability.

  Vulnerability Insight:
  Error in a script in '/admin/remotecontrol/' and can be exploited to view and
  manipulate files, which may allow the execution of e.g. arbitrary PHP code.

  Impact:
  Successful exploitation will let the attacker gain sensitive information by
  executing arbitrary commands inside the context of the affected web application.

  Impact Level: Application

  Affected Software/OS:
  LimeSurvey version prior to 1.82

  Fix:
  Upgrade to LimeSurvey version 1.82 or later
  http://www.limesurvey.org/content/view/22/82/lang,en

  References:
  http://secunia.com/advisories/34946
  http://www.vupen.com/english/advisories/2009/1219
  http://www.limesurvey.org/content/view/169/1/lang,en

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of LimeSurvey");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("secpod_limesurvey_detect.nasl");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

surveyPort = get_http_port(default:80);
if(!surveyPort){
  exit(0);
}

surveyVer = get_kb_item("www/"+ surveyPort + "/LimeSurvey");
if(surveyVer == NULL){
  exit(0);
}

ver = eregmatch(pattern:"^(.+) under (/.*)$", string:surveyVer);
if(ver[1] != NULL)
{
  # Check for LimeSurvey version prior to 1.82
  if(version_is_less(version:ver[1], test_version:"1.82")){
    security_hole(surveyPort);
  }
}
