##############################################################################
#
#  Google Chrome multiple vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/10
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0182
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900214);
 script_bugtraq_id(30975, 30983, 31000, 31029, 31031, 31034, 31035, 31038);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"Google Chrome multiple vulnerabilities");
 script_summary(english:"Check for Google Chrome Engine version");
 desc["english"] = "
 Overview : This host has Google Chrome web browser installed, which is prone
 to arbitrary code execution and Denial of Service Vulnerabilities.

 Vulnerability Insight :
        Multiple flaws are due to, 
        - the Browser failing to handle specially crafted HTML img tags,
          certain user-supplied data, HTTP view-source headers, and HTML
          href tags. 
        - the Browser allows users to download arbitrary files without
          confirmation. 
        - the Browser fails to perform adequate validation on
          user supplied data. 

        Impact : A remote user could cause Denial of Service conditions
        or can execute arbitrary code by convincing the users to visit 
        a malicious website.

 Impact Level : Application

 Affected Software/OS :
        Google Chrome 0.2.149.27 version on Windows (All).

 Fix : Upgrade to Google Chrome 0.2.149.29 or later. 
 http://www.google.com/chrome

 *****
 NOTE : Please ignore this warning, if upgraded/installed with higher version.
 *****

 References : http://www.google.com/chrome
 http://evilfingers.com/advisory/google_chrome_poc.php
 http://securitytracker.com/alerts/2008/Sep/1020823.html

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.5
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 if(!registry_key_exists(key:"SOFTWARE\Classes\Applications\chrome.exe")){
        exit(0);
 }

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 if(!port){
	port = 139;
 }

 if(!get_port_state(port)){
        exit(0);
 }

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }


 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\Folders";
 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
                          key:key, reply:handle);
 if(key_h)
 {
        enumValues = registry_enum_value(soc:soc, uid:uid, tid:tid,
                                         pipe:pipe, reply:key_h);
 }

 close(soc);
 if(enumValues == NULL){
        exit(0);
 }

 foreach entry (enumValues)
 {
        if(egrep(pattern:"(.*Chrome\\Application\\)$", string:entry)){
		break;
        }
 }

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:entry);
 file1 =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:entry);
 file2 =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:entry);

 file1 = file1 + "0.2.149.29\chrome.dll";
 file2 = file2 + "0.2.149.27\chrome.dll";

 soc = open_sock_tcp(port);
 if(!soc){
	exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file1);
 if(!fid)
 {
        fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file2);
        if(!fid)
        {
            close(soc);
            exit(0);
        }
 }

 fileVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, offset:8469000);
 close(soc);

 if(!fileVer){
        exit(0);
 } 

 if(egrep(pattern:"^0\.2\.149\.2[0-8][0-9]?$", string:fileVer)){
        security_hole(0);
 }
