###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_google_chrome_cmd_exec_vuln.nasl 795 2008-12-30 17:40:29Z dec $
#
# Google Chrome Argument Injection Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900419);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5749");
  script_bugtraq_id(32997);
  script_name(english:"Google Chrome Argument Injection Vulnerability");
  desc["english"] = "

  Overview: This host has installed Google Chrome and is prone to argument
  injection vulnerability.

  Vulnerability Insight:
  The flaw is due to lack of sanitization check of user supplied input via
  --renderer-path option in a chromehtml: URI.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code
  in the context of the web browser and can compromise the remote system
  by executing mailcious commands.

  Affected Software/OS:
  Google Chrome version 1.0.154.36 and prior on Windows

  Fix: No solution or patch is available as on 31st December 2008, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.google.com/chrome

  References:
  http://www.milw0rm.com/exploits/7566
  http://www.securityfocus.com/archive/1/archive/1/499581/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_family(english:"General");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

if(version_is_less_equal(version:chromeVer, test_version:"1.0.154.36")){
  security_warning(0);
}
