###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_mult_vuln_apr09_win.nasl 1903 2009-04-24 12:54:33Z apr $
#
# Mozilla Firefox Multiple Vulnerabilities Apr-09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900342);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1304", "CVE-2009-1305",
                "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1308", "CVE-2009-1309",
                "CVE-2009-1310", "CVE-2009-1311", "CVE-2009-1312");
  script_bugtraq_id(34656);
  script_name(english:"Mozilla Firefox Multiple Vulnerabilities Apr-09 (Win)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Firefox browser and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  For more information about vulnerabilities on Firefox, go through the links
  mentioned in references.

  Impact:
  Successful exploitation could result in Information Disclosure, XSS, Script
  Injection, Memory Corruption, CSRF, Arbitrary JavaScript code execution or
  can cause denial of service attacks.

  Impact Level: System/Application

  Affected Software/OS:
  Firefox version prior to 3.0.9 on Windows.

  Fix: Upgrade to Firefox version 3.0.9
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/advisories/34758
  http://www.mozilla.org/security/announce/2009/mfsa2009-14.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-16.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-17.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-18.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-19.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-20.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-21.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-22.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version prior to 3.0.9
if(version_is_less(version:ffVer, test_version:"3.0.9")){
  security_hole(0);
}
