###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_elecard_avchd_player_bof_vuln.nasl 1870 2009-04-28 15:56:36Z apr $
#
# Elecard AVC HD  Player Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
# #
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900627);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1356");
  script_bugtraq_id(34560);
  script_name(english:"Elecard AVC HD  Player Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is installed Elecard AVC HD Player and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  Application fails to perform adequate boundary checks on user-supplied input
  which results in a buffer overflow while processing playlist(.xpl) containing
  long MP3 filenames.

  Impact: Successful exploitation will allows attacker to execute arbitrary code
  in the context of the affected application.

  Impact Level: Application

  Affected Software/OS:
  Elecard AVC HD Player 5.5.90213 and prior on Windows.

  Fix: No solution or patch is available as on 29th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.elecard.com/download/index.php

  References:
  http://www.milw0rm.com/exploits/8452
  http://en.securitylab.ru/nvd/378145.php

  CVSS Score:
    CVSS Base Score    : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score: 8.4
  Risk factor :Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Elecard AVC HD Player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_elecard_avchd_player_detect.nasl");
  script_require_keys("Elecard/AVC/HD/Ver");
  exit(0);
}


include("version_func.inc");

avcPlayer = get_kb_item("Elecard/AVC/HD/Ver");
if(!avcPlayer){
  exit(0);
}

if(version_is_less_equal(version:avcPlayer, test_version:"5.5.90213")){
  security_hole(0);
}
