# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:085 (gstreamer0.10-plugins-base)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63718);
 script_cve_id("CVE-2008-4316", "CVE-2009-0586");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:085 (gstreamer0.10-plugins-base)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gstreamer0.10-plugins-base
announced via advisory MDVSA-2009:085.

Integer overflows in gstreamer0.10-plugins-base Base64 encoding and
decoding functions (related with glib2.0 issue CVE-2008-4316) may
lead attackers to cause denial of service. Altough vector attacks
are not known yet (CVE-2009-0586).

This update provide the fix for that security issue.

Affected: 2008.0, 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:085

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:085 (gstreamer0.10-plugins-base)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gstreamer0.10-cdparanoia", rpm:"gstreamer0.10-cdparanoia~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-gnomevfs", rpm:"gstreamer0.10-gnomevfs~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-libvisual", rpm:"gstreamer0.10-libvisual~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-plugins-base", rpm:"gstreamer0.10-plugins-base~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstreamer-plugins-base0.10", rpm:"libgstreamer-plugins-base0.10~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstreamer-plugins-base0.10-devel", rpm:"libgstreamer-plugins-base0.10-devel~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstreamer-plugins-base0.10", rpm:"lib64gstreamer-plugins-base0.10~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstreamer-plugins-base0.10-devel", rpm:"lib64gstreamer-plugins-base0.10-devel~0.10.14~1.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-cdparanoia", rpm:"gstreamer0.10-cdparanoia~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-gnomevfs", rpm:"gstreamer0.10-gnomevfs~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-libvisual", rpm:"gstreamer0.10-libvisual~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-plugins-base", rpm:"gstreamer0.10-plugins-base~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstreamer-plugins-base0.10", rpm:"libgstreamer-plugins-base0.10~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstreamer-plugins-base0.10-devel", rpm:"libgstreamer-plugins-base0.10-devel~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstreamer-plugins-base0.10", rpm:"lib64gstreamer-plugins-base0.10~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstreamer-plugins-base0.10-devel", rpm:"lib64gstreamer-plugins-base0.10-devel~0.10.17~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-cdparanoia", rpm:"gstreamer0.10-cdparanoia~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-gnomevfs", rpm:"gstreamer0.10-gnomevfs~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-libvisual", rpm:"gstreamer0.10-libvisual~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer0.10-plugins-base", rpm:"gstreamer0.10-plugins-base~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstreamer-plugins-base0.10", rpm:"libgstreamer-plugins-base0.10~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgstreamer-plugins-base0.10-devel", rpm:"libgstreamer-plugins-base0.10-devel~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstreamer-plugins-base0.10", rpm:"lib64gstreamer-plugins-base0.10~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64gstreamer-plugins-base0.10-devel", rpm:"lib64gstreamer-plugins-base0.10-devel~0.10.20~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
