#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{
  script_id(90026);
  script_version ("$Revision: 01 $");
  script_cve_id("CVE-2008-1948");
  name["english"] = "GnuTLS < 2.2.5 vulnerability (Lin)";
  script_name(english:name["english"]);

  desc["english"] = "The remote host is probably affected by the vulnerabilities
  described in CVE-2008-1948, CVE-2008-1949, CVE-2008-1950

  Impact:
  CVE-2008-1948
    The _gnutls_server_name_recv_params function in lib/ext_server_name.c
    in libgnutls in gnutls-serv in GnuTLS before 2.2.4 does not properly
    calculate the number of Server Names in a TLS 1.0 Client Hello
    message during extension handling, which allows remote attackers
    to cause a denial of service (crash) or possibly execute arbitrary
    code via a zero value for the length of Server Names, which leads
    to a buffer overflow in session resumption data in the
    pack_security_parameters function, aka GNUTLS-SA-2008-1-1.

  CVE-2008-1949
    The _gnutls_recv_client_kx_message function in lib/gnutls_kx.c
    in libgnutls in gnutls-serv in GnuTLS before 2.2.4 continues to
    process Client Hello messages within a TLS message after one has
    already been processed, which allows remote attackers to cause a
    denial of service (NULL dereference and crash) via a TLS message
    containing multiple Client Hello messages, aka GNUTLS-SA-2008-1-2.

  CVE 2008-1950
    Integer signedness error in the _gnutls_ciphertext2compressed
    function in lib/gnutls_cipher.c in libgnutls in GnuTLS before 2.2.4
    allows remote attackers to cause a denial of service (buffer over-read
    and crash) via a certain integer value in the Random field in an
    encrypted Client Hello message within a TLS record with an invalid
    Record Length, which leads to an invalid cipher padding length,
    aka GNUTLS-SA-2008-1-3.

  References:
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1948
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1949
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1950

  Solution:
  All GnuTLS users should upgrade to the latest version:

  Risk factor : High";

  script_description(english:desc["english"]);
  summary["english"] = "Determines GnuTLS < 2.2.5 vulnerability";
  script_summary(english:summary["english"]);
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is under GPLv2");
  family["english"] = "Local test";
  script_family(english:family["english"]);
  exit(0);
}

#
# The code starts here
#


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

gnuPath = find_file(file_name:"gnutls-cli", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);
foreach gnutlsBin (gnuPath)
{
  gnutlsVer = get_bin_version(full_prog_name:chomp(gnutlsBin), sock:sock,
                             version_argv:"--version",
                             ver_pattern:"version ([0-9.]+)");
  if(gnutlsVer[1] != NULL)
  {
    # Grep for GnuTLS Version prior to 2.2.4
    if(version_is_less(version:gnutlsVer[1], test_version:"2.2.4")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
