# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(60941);
 script_cve_id("CVE-2008-1142", "CVE-2008-1692");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200805-03 (aterm eterm rxvt mrxvt multi-aterm wterm rxvt-unicode)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200805-03.

A vulnerability was found in aterm, Eterm, Mrxvt, multi-aterm, RXVT,
rxvt-unicode, and wterm, allowing for local privilege escalation.

Solution:
All aterm users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-terms/aterm-1.0.1-r1'

All Eterm users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-terms/eterm-0.9.4-r1'

All Mrxvt users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-terms/mrxvt-0.5.3-r2'

All multi-aterm users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-terms/multi-aterm-0.2.1-r1'

All RXVT users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-terms/rxvt-2.7.10-r4'

All rxvt-unicode users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-terms/rxvt-unicode-9.02-r1'

All wterm users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=x11-terms/wterm-6.2.9-r3'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200805-03
http://bugs.gentoo.org/show_bug.cgi?id=216833
http://bugs.gentoo.org/show_bug.cgi?id=217819
http://bugs.gentoo.org/show_bug.cgi?id=219746
http://bugs.gentoo.org/show_bug.cgi?id=219750
http://bugs.gentoo.org/show_bug.cgi?id=219754
http://bugs.gentoo.org/show_bug.cgi?id=219760
http://bugs.gentoo.org/show_bug.cgi?id=219762

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200805-03 (aterm eterm rxvt mrxvt multi-aterm wterm rxvt-unicode)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"x11-terms/aterm", unaffected: make_list("ge 1.0.1-r1"), vulnerable: make_list("lt 1.0.1-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"x11-terms/eterm", unaffected: make_list("ge 0.9.4-r1"), vulnerable: make_list("lt 0.9.4-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"x11-terms/mrxvt", unaffected: make_list("ge 0.5.3-r2"), vulnerable: make_list("lt 0.5.3-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"x11-terms/multi-aterm", unaffected: make_list("ge 0.2.1-r1"), vulnerable: make_list("lt 0.2.1-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"x11-terms/rxvt", unaffected: make_list("ge 2.7.10-r4"), vulnerable: make_list("lt 2.7.10-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"x11-terms/rxvt-unicode", unaffected: make_list("ge 9.02-r1"), vulnerable: make_list("lt 9.02-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"x11-terms/wterm", unaffected: make_list("ge 6.2.9-r3"), vulnerable: make_list("lt 6.2.9-r3"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
