# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(59642);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200711-34 (cstetex)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200711-34.

Multiple vulnerabilities were discovered in CSTeX, possibly allowing to
execute arbitrary code or overwrite arbitrary files.

Solution:
CSTeX is not maintained upstream, so the package was masked in Portage. We
recommend that users unmerge CSTeX:

    # emerge --unmerge app-text/cstetex

As an alternative, users should upgrade their systems to use teTeX or TeX
Live with its Babel packages.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200711-34
http://bugs.gentoo.org/show_bug.cgi?id=196673
http://www.gentoo.org/security/en/glsa/glsa-200708-05.xml
http://www.gentoo.org/security/en/glsa/glsa-200709-12.xml
http://www.gentoo.org/security/en/glsa/glsa-200709-17.xml
http://www.gentoo.org/security/en/glsa/glsa-200710-12.xml
http://www.gentoo.org/security/en/glsa/glsa-200711-22.xml
http://www.gentoo.org/security/en/glsa/glsa-200711-26.xml

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200711-34 (cstetex)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-text/cstetex", unaffected: make_list(), vulnerable: make_list("lt 2.0.2-r2"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
