# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(56551);
 script_bugtraq_id(17217);
 script_cve_id("CVE-2006-1390");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200603-23 (nethack slashem falconseye)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200603-23.

NetHack, Slash'EM and Falcon's Eye are vulnerable to local privilege
escalation vulnerabilities that could potentially allow the execution of
arbitrary code as other users.

Solution:
NetHack has been masked in Portage pending the resolution of these issues.
Vulnerable NetHack users are advised to uninstall the package until
further notice.

    # emerge --ask --verbose --unmerge 'games-roguelike/nethack'

Slash'EM has been masked in Portage pending the resolution of these
issues. Vulnerable Slash'EM users are advised to uninstall the package
until further notice.

    # emerge --ask --verbose --unmerge 'games-roguelike/slashem'

Falcon's Eye has been masked in Portage pending the resolution of these
issues. Vulnerable Falcon's Eye users are advised to uninstall the package
until further notice.

    # emerge --ask --verbose --unmerge 'games-roguelike/falconseye'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200603-23
http://bugs.gentoo.org/show_bug.cgi?id=125902
http://bugs.gentoo.org/show_bug.cgi?id=122376
http://bugs.gentoo.org/show_bug.cgi?id=127167
http://bugs.gentoo.org/show_bug.cgi?id=127319

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200603-23 (nethack slashem falconseye)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"games-roguelike/nethack", unaffected: make_list(), vulnerable: make_list("le 3.4.3-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"games-roguelike/falconseye", unaffected: make_list(), vulnerable: make_list("le 1.9.4a"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"games-roguelike/slashem", unaffected: make_list(), vulnerable: make_list("le 0.0.760"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
