# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(55091);
 script_bugtraq_id(14529);
 script_cve_id("CVE-2005-2097");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200508-08 (xpdf kpdf gpdf)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200508-08.

Xpdf, Kpdf and GPdf may crash as a result of a Denial of Service
vulnerability.

Solution:
All Xpdf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/xpdf-3.00-r10'

All GPdf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/gpdf-2.10.0-r1'

All Kpdf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=kde-base/kdegraphics-3.3.2-r3'

All KDE Split Ebuild Kpdf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=kde-base/kpdf-3.4.1-r1'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200508-08
http://bugs.gentoo.org/show_bug.cgi?id=99769
http://bugs.gentoo.org/show_bug.cgi?id=100263
http://bugs.gentoo.org/show_bug.cgi?id=100265

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200508-08 (xpdf kpdf gpdf)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-text/xpdf", unaffected: make_list("ge 3.00-r10"), vulnerable: make_list("lt 3.00-r10"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"kde-base/kdegraphics", unaffected: make_list("ge 3.3.2-r3"), vulnerable: make_list("lt 3.3.2-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"kde-base/kpdf", unaffected: make_list("ge 3.4.1-r1"), vulnerable: make_list("lt 3.4.1-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-text/gpdf", unaffected: make_list("ge 2.10.0-r1"), vulnerable: make_list("lt 2.10.0-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
