# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54708);
 script_bugtraq_id(11151);
 script_cve_id("CVE-2004-0752");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200410-17 (openoffice)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200410-17.

OpenOffice.org uses insecure temporary files which could allow a malicious
local user to gain knowledge of sensitive information from other users'
documents.

Solution:
All affected OpenOffice.org users should upgrade to the latest version:

    # emerge sync

    # emerge -pv '>=app-office/openoffice-1.1.3'
    # emerge '>=app-office/openoffice-1.1.3'

All affected OpenOffice.org binary users should upgrade to the latest
version:

    # emerge sync

    # emerge -pv '>=app-office/openoffice-bin-1.1.3'
    # emerge '>=app-office/openoffice-bin-1.1.3'

All affected OpenOffice.org Ximian users should upgrade to the latest
version:

    # emerge sync

    # emerge -pv '>=app-office/openoffice-ximian-1.3.4'
    # emerge '>=app-office/openoffice-1.3.4'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200410-17
http://bugs.gentoo.org/show_bug.cgi?id=63556
http://www.openoffice.org/issues/show_bug.cgi?id=33357

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200410-17 (openoffice)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-office/openoffice", unaffected: make_list("lt 1.1.2", "ge 1.1.3"), vulnerable: make_list("eq 1.1.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/openoffice-bin", unaffected: make_list("lt 1.1.2", "ge 1.1.3"), vulnerable: make_list("eq 1.1.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/openoffice-ximian", unaffected: make_list("lt 1.1.60", "ge 1.3.4"), vulnerable: make_list("eq 1.1.60", "eq 1.1.61"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
