# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54511);
 script_bugtraq_id(9115);
 script_cve_id("CVE-2003-0971");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200312-05 (GnuPG)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200312-05.

A bug in GnuPG allows ElGamal signing keys to be compromised, and a format
string bug in the gpgkeys_hkp utility may allow arbitrary code execution.

Solution:
All users who have created ElGamal signing keys should immediately revoke
them.  In addition, all Gentoo Linux machines with gnupg installed should
be updated to use gnupg-1.2.3-r5 or higher:

    # emerge sync
    # emerge -pv '>=app-crypt/gnupg-1.2.3-r5'
    # emerge '>=app-crypt/gnupg-1.2.3-r5'
    # emerge clean

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200312-05
http://bugs.gentoo.org/show_bug.cgi?id=34504
http://marc.theaimsgroup.com/?l=gnupg-announce&m=106992378510843&q=raw
http://www.s-quadra.com/advisories/Adv-20031203.txt

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200312-05 (GnuPG)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-crypt/gnupg", unaffected: make_list("ge 1.2.3-r5"), vulnerable: make_list("le 1.2.3-r4"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
