# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54501);
 script_bugtraq_id(8853);
 script_cve_id("CVE-2003-0870");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200311-02 (Opera)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200311-02.

Buffer overflows exist in Opera 7.11 and 7.20 that can cause Opera to
crash, and can potentially overwrite arbitrary bytes on the heap leading
to a system compromise.

Solution:
Users are encouraged to perform an 'emerge sync' and upgrade the package to
the latest available version.  Opera 7.22 is recommended as Opera 7.21 is
vulnerable to other security flaws. Specific steps to upgrade:

    # emerge sync
    # emerge -pv '>=net-www/opera-7.22'
    # emerge '>=net-www/opera-7.22'
    # emerge clean

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200311-02
http://bugs.gentoo.org/show_bug.cgi?id=31775
http://www.atstake.com/research/advisories/2003/a102003-1.txt

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200311-02 (Opera)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-www/opera", unaffected: make_list("ge 7.21"), vulnerable: make_list("eq 7.20", "eq 7.11"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
