# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54499);
 script_cve_id("CVE-2003-0789", "CVE-2003-0542");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200310-04 (Apache)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200310-04.

Multiple stack-based buffer overflows in mod_alias and mod_rewrite can
allow execution of arbitrary code and cause a denial of service, and a bug
in the way mod_cgid handles CGI redirect paths could result in CGI output
going to the wrong client.

Solution:
It is recommended that all Gentoo Linux users who are running
net-misc/apache 2.x upgrade:

    # emerge sync
    # emerge -pv '>=net-www/apache-2.0.48'
    # emerge '>=net-www/apache-2.0.48'
    # emerge clean
    # /etc/init.d/apache2 restart

Please remember to update your config files in /etc/apache2 as --datadir
has been changed to /var/www/localhost.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200310-04
http://bugs.gentoo.org/show_bug.cgi?id=32271

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200310-04 (Apache)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-www/apache", unaffected: make_list("ge 2.0.48", "lt 2.0"), vulnerable: make_list("lt 2.0.48"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
