###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_win_xp_chm_dos_vuln.nasl 0848 2009-01-16 15:06:24Z Jan $
#
# Microsoft Windows XP SP3 denial of service vulnerability.
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800504);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0119");
  script_bugtraq_id(33204);
  script_name(english:"Microsoft Windows XP SP3 denial of service vulnerability");
  desc["english"] = "

  Overview: The host is running Microsoft Windows XP which is prone to
  denial of service vulnerability.

  Vulnerability Insight:
  The flaw is due to an error generated in Windows XP while handling CHM
  files causing buffer overflow.

  Impact:
  Successful remote exploitation could result in administrator access,
  unauthorized disclosure of information and disruption of service by
  executing arbitrary code.

  Impact Level: System/Network

  Affected Software/OS:
  Microsoft Windows XP SP3 and prior.

  Fix: No solution or patch is available as on 19th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.securityfocus.com/bid/33204/solution

  References:
  http://www.milw0rm.com/exploits/7720
  http://web.nvd.nist.gov/view/vuln/detail?execution=e3s1
  http://www.security-database.com/detail.php?alert=CVE-2009-0119

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor : Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Microsoft Windows");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("secpod_reg.inc");

if("5.1" != get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(hotfix_check_sp(xp:4)){
 security_hole(0);
}
