###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for yast2-backup SUSE-SA:2008:054
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850016);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-054");
  script_cve_id("CVE-2008-4636");
  script_name(english: "SuSE Update for yast2-backup SUSE-SA:2008:054");
  desc["english"] = "

  Vulnerability Insight:

  Insufficient shell quoting in yast2-backup allowed local users to
  craft special file names that inject shell code into the backup
  process CVE-2008-4636.

  Impact:
  local privilege escalation

  Affected Software/OS:
  yast2-backup on openSUSE 10.2, openSUSE 10.3, openSUSE 11.0, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1, SUSE Linux Enterprise Desktop 10 SP2, SUSE Linux Enterprise Server 10 SP2

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_54_yast2_backup.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of yast2-backup");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.9.22~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.9.22~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.9.22~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP2")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.13.6~0.1", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.13.6~0.1", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.9.22~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP2")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.13.6~0.1", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"yast2-backup", rpm:"yast2-backup~2.13.6~0.1", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}