###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for java-1_5_0-ibm,IBMJava5 SUSE-SA:2008:045
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850007);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-045");
  script_cve_id("CVE-2008-3104", "CVE-2008-3106", "CVE-2008-3108", "CVE-2008-3111", "CVE-2008-3112", "CVE-2008-3113", "CVE-2008-3114");
  script_name(english: "SuSE Update for java-1_5_0-ibm,IBMJava5 SUSE-SA:2008:045");
  desc["english"] = "

  Vulnerability Insight:

  IBM Java 5 was updated to SR8 to fix various security issues, listed below.

  This is a respin of the update already listed in SUSE-SA:2008:043,
  with corrected cryptographic policy jar files, which got lost between
  the SR3 and SR8 updates.

  CVE-2008-3104: Multiple vulnerabilities with unsigned applets were
  reported. A remote attacker could misuse an unsigned applet to connect
  to localhost services running on the host running the applet.

  CVE-2008-3106: A vulnerability in the XML processing API was found. A
  remote attacker who caused malicious XML to be processed by an
  untrusted applet or application was able to elevate permissions to
  access URLs on a remote host.

  CVE-2008-3108: A buffer overflow vulnerability was found in the
  font processing code. This allowed remote attackers to extend the
  permissions of an untrusted applet or application, allowing it to read
  and/or write local files, as well as to execute local applications
  accessible to the user running the untrusted application.

  CVE-2008-3111: Several buffer overflow vulnerabilities in Java Web
  Start were reported. These vulnerabilities allowed an untrusted Java
  Web Start application to elevate its privileges, allowing it to read
  and/or write local files, as well as to execute local applications
  accessible to the user running the untrusted application.

  CVE-2008-3113: Two file processing vulnerabilities
  in Java Web Start were found. A remote attacker, by means of an
  untrusted Java Web Start application, was able to create or delete
  arbitrary files with the permissions of the user running the untrusted
  application.

  CVE-2008-3114: A vulnerability in Java Web Start when processing
  untrusted applications was reported. An attacker was able to acquire
  sensitive information, such as the cache location.

  Impact:
  remote code execution

  Affected Software/OS:
  java-1_5_0-ibm,IBMJava5 on SUSE SLES 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1, SUSE Linux Enterprise Desktop 10 SP2, SUSE Linux Enterprise Server 10 SP2

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_45_ibmjava.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of java-1_5_0-ibm,IBMJava5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"IBMJava5-JRE", rpm:"IBMJava5-JRE~1.5.0~0.43", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-SDK", rpm:"IBMJava5-SDK~1.5.0~0.43", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-JRE", rpm:"IBMJava5-JRE~1.5.0~0.50", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-SDK", rpm:"IBMJava5-SDK~1.5.0~0.50", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"IBMJava5-JRE", rpm:"IBMJava5-JRE~1.5.0~0.43", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-SDK", rpm:"IBMJava5-SDK~1.5.0~0.43", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-JRE", rpm:"IBMJava5-JRE~1.5.0~0.50", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-SDK", rpm:"IBMJava5-SDK~1.5.0~0.50", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"IBMJava5-JRE", rpm:"IBMJava5-JRE~1.5.0~0.43", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-SDK", rpm:"IBMJava5-SDK~1.5.0~0.43", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-JRE", rpm:"IBMJava5-JRE~1.5.0~0.50", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"IBMJava5-SDK", rpm:"IBMJava5-SDK~1.5.0~0.50", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP2")
{

  if(isrpmvuln(pkg:"java-1_5_0-ibm", rpm:"java-1_5_0-ibm~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa", rpm:"java-1_5_0-ibm-alsa~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-demo", rpm:"java-1_5_0-ibm-demo~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel", rpm:"java-1_5_0-ibm-devel~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-jdbc", rpm:"java-1_5_0-ibm-jdbc~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-plugin", rpm:"java-1_5_0-ibm-plugin~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-src", rpm:"java-1_5_0-ibm-src~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-32bit", rpm:"java-1_5_0-ibm-32bit~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa-32bit", rpm:"java-1_5_0-ibm-alsa-32bit~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel-32bit", rpm:"java-1_5_0-ibm-devel-32bit~1.5.0_sr8~1.3", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"java-1_5_0-ibm", rpm:"java-1_5_0-ibm~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa", rpm:"java-1_5_0-ibm-alsa~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-demo", rpm:"java-1_5_0-ibm-demo~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel", rpm:"java-1_5_0-ibm-devel~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-jdbc", rpm:"java-1_5_0-ibm-jdbc~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-plugin", rpm:"java-1_5_0-ibm-plugin~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-src", rpm:"java-1_5_0-ibm-src~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-32bit", rpm:"java-1_5_0-ibm-32bit~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa-32bit", rpm:"java-1_5_0-ibm-alsa-32bit~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel-32bit", rpm:"java-1_5_0-ibm-devel-32bit~1.5.0_sr8~1.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP2")
{

  if(isrpmvuln(pkg:"java-1_5_0-ibm", rpm:"java-1_5_0-ibm~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa", rpm:"java-1_5_0-ibm-alsa~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-demo", rpm:"java-1_5_0-ibm-demo~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel", rpm:"java-1_5_0-ibm-devel~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-jdbc", rpm:"java-1_5_0-ibm-jdbc~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-plugin", rpm:"java-1_5_0-ibm-plugin~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-src", rpm:"java-1_5_0-ibm-src~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-32bit", rpm:"java-1_5_0-ibm-32bit~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa-32bit", rpm:"java-1_5_0-ibm-alsa-32bit~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel-32bit", rpm:"java-1_5_0-ibm-devel-32bit~1.5.0_sr8~1.3", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"java-1_5_0-ibm", rpm:"java-1_5_0-ibm~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa", rpm:"java-1_5_0-ibm-alsa~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-demo", rpm:"java-1_5_0-ibm-demo~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel", rpm:"java-1_5_0-ibm-devel~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-jdbc", rpm:"java-1_5_0-ibm-jdbc~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-plugin", rpm:"java-1_5_0-ibm-plugin~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-src", rpm:"java-1_5_0-ibm-src~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-32bit", rpm:"java-1_5_0-ibm-32bit~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-alsa-32bit", rpm:"java-1_5_0-ibm-alsa-32bit~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"java-1_5_0-ibm-devel-32bit", rpm:"java-1_5_0-ibm-devel-32bit~1.5.0_sr8~1.3", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}