###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for MozillaFirefox SUSE-SA:2007:066
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850108);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-066");
  script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");
  script_name(english: "SuSE Update for MozillaFirefox SUSE-SA:2007:066");
  desc["english"] = "

  Vulnerability Insight:

  The Mozilla Firefox packages were brought to security update version
  2.0.0.10 for SUSE Linux Enterprise 10, SUSE Linux 10.0, 10.1 and
  openSUSE 10.2 and 10.3.

  These packages include the Canvas regression fix also fixed in
  2.0.0.11, so we are effectively at 2.0.0.11 with our packages.

  Mozilla Firefox for Novell Linux Desktop 9 is still being prepared,
  same for Mozilla Thunderbird 2.0.0.9 and Mozilla and Seamonkey Suite
  packages.

  The update was released on 29th of November.

  Following security problems were fixed:
  CVE-2007-5947: The jar protocol handler in Mozilla
  Firefox retrieves the inner URL regardless of its MIME type, and
  considers HTML documents within a jar archive to have the same origin
  as the inner URL, which allows remote attackers to conduct cross-site
  scripting (XSS) attacks via a jar: URI.

  CVE-2007-5959:
  The Firefox 2.0.0.10 update contains fixes for three bugs that improve
  the stability of the product. These crashes showed some evidence of
  memory corruption under certain circumstances and we presume that
  with enough effort at least some of these could be exploited to run
  arbitrary code.

  CVE-2007-5960:
  Gregory Fleischer demonstrated that it was possible to generate a fake
  HTTP Referer header by exploiting a timing condition when setting the
  window.location property. This could be used to conduct a Cross-site
  Request Forgery (CSRF) attack against websites that rely only on the
  Referer header as protection against such attacks.

  Impact:
  remote code execution

  Affected Software/OS:
  MozillaFirefox on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_66_firefox.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of MozillaFirefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~2.0.0.10~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~2.0.0.10~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~2.0.0.10~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~2.0.0.10~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~2.0.0.10~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~2.0.0.10~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~2.0.0.10~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~2.0.0.10~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~2.0.0.10~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~2.0.0.10~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}