###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for flash-player SUSE-SA:2007:046
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850114);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-046");
  script_cve_id("CVE-2007-2022", "CVE-2007-3456", "CVE-2007-3457");
  script_name(english: "SuSE Update for flash-player SUSE-SA:2007:046");
  desc["english"] = "

  Vulnerability Insight:

  The Adobe Flash Player was updated to fix various security issues.

  New versions:
  - Flash 7.0.70.0: SUSE Linux 10.0, Novell Linux Desktop 9,
  SUSE Linux Desktop 1.0 and SUSE Linux Enterprise Server 8

  - Flash 9.0.48.0: SUSE Linux 10.1, openSUSE 10.2 and SUSE Linux
  Enterprise Desktop 10.

  Security issues resolved:
  - CVE-2007-3456: An input validation error has been identified in
  Flash Player 9.0.45.0 and earlier versions that could lead to the
  potential execution of arbitrary code.  This vulnerability could
  be accessed through content delivered from a remote location via
  the user's web browser, email client, or other applications that
  include or reference the Flash Player.

  - CVE-2007-3457: An issue with insufficient validation of the HTTP
  Referer has been identified in Flash Player 8.0.34.0 and
  earlier. This issue does not affect Flash Player 9. This issue
  could potentially aid an attacker in executing a cross-site request
  forgery attack.

  - CVE-2007-2022: The Linux and Solaris updates for Flash Player 7
  (7.0.70.0) address the issues with Flash Player and the Opera and
  Konqueror browsers described in Security Advisory APSA07-03. These
  issues do not impact Flash Player 9 on Linux or Solaris.

  The web browsers Opera and konqueror that were affected by CVE-2007-2022
  have already been fixed independently.

  Impact:
  remote code execution

  Affected Software/OS:
  flash-player on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, Novell Linux Desktop 9, SUSE Linux Enterprise Desktop 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_46_flashplayer.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of flash-player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"netscape-plugins", rpm:"netscape-plugins~7.0.70~0.1", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"netscape-plugins", rpm:"netscape-plugins~4.80~116", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.48.0~1.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~7.0.70.0~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.48.0~1.2", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~7.0.70.0~0.1", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.48.0~1.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.48.0~1.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}