###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ntp_sec_bypass_vuln.nasl 824 2009-01-13 15:05:27Z jan $
#
# NTP EVP_VerifyFinal() Security Bypass Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800408);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0021");
  script_bugtraq_id(33150);
  script_name(english:"NTP EVP_VerifyFinal() Security Bypass Vulnerability");
  desc["english"] = "

  Overview: This host has NTP installed and is prone to security bypass
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of return value in
  EVP_VerifyFinal function of openssl.

  Impact:
  Successful exploitation could allow remote attackers to bypass the certificate
  validation checks and can cause spoofing attacks via signature checks on DSA
  and ECDSA keys used with SSL/TLS.

  Impact Level: System/Application

  Affected Software/OS:
  NTP version 4.2.4 to 4.2.4p5 and 4.2.5 to 4.2.5p150 on Linux.

  Fix: Upgrade to NTP version 4.2.4p6 or 4.2.5p151
  http://www.ntp.org/downloads.html

  References:
  http://www.securityfocus.com/archive/1/499827
  http://www.securityfocus.com/archive/1/499855
  http://www.ocert.org/advisories/ocert-2008-016.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of NTP");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("gb_ntp_detect_lin.nasl");
  script_require_keys("NTP/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ntpVer = get_kb_item("NTP/Linux/Ver");
if(!ntpVer){
  exit(0);
}

# version 4.2.4 t0 4.2.4.p5 and 4.2.5 to 4.2.5.p150
if(version_in_range(version:ntpVer, test_version:"4.2.4",
                    test_version2:"4.2.4.p5")||
   version_in_range(version:ntpVer, test_version:"4.2.5",
                    test_version2:"4.2.5.p150")){
  security_warning(port:ntpPort, proto:"udp");
}
