###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_detect.nasl 714 2008-12-17 13:15:29Z dec $
#
# Microsoft Internet Explorer Version Detection (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800209);
  script_version("$Revision: 1.0 $");
  script_name(english:"Microsoft Internet Explorer Version Detection (Win)");
  desc["english"] = "
  Overview: The script detects the version of Microsoft Internet Explorer
  on remote host and sets the KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Check for Internet Explorer version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl", "smb_registry_access.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Internet Explorer")){
  exit(0);
}

ver = registry_get_sz(item:"Version",
                      key:"SOFTWARE\Microsoft\Internet Explorer");
if(ver != NULL){
  set_kb_item(name:"MS/IE/Version", value:ver);
}
