###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mplayer MDVSA-2008:219 (mplayer)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830646);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:219");
  script_cve_id("CVE-2008-0073", "CVE-2008-3827");
  script_name(english: "Mandriva Update for mplayer MDVSA-2008:219 (mplayer)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability that was discovered in xine-lib that allowed remote
  RTSP servers to execute arbitrary code via a large streamid SDP
  parameter also affects MPlayer (CVE-2008-0073).
  
  Several integer overflows were discovered by Felipe Andres Manzano
  in MPlayer's Real video stream demuxing code.  These vulnerabilities
  could allow an attacker to cause a crash or possibly execute arbitrary
  code by supplying a malicious crafted video file (CVE-2008-3827).
  
  The updated packages have been patched to fix these issues.
  Note that CVE-2008-3827 was already corrected in the Mandriva Linux
  2009 packages.

  Affected Software/OS:
  mplayer on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00048.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mplayer");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libdha1.0", rpm:"libdha1.0~1.0~1.rc1.20.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mencoder", rpm:"mencoder~1.0~1.rc1.20.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer", rpm:"mplayer~1.0~1.rc1.20.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-doc", rpm:"mplayer-doc~1.0~1.rc1.20.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-gui", rpm:"mplayer-gui~1.0~1.rc1.20.5mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"mencoder", rpm:"mencoder~1.0~1.rc2.10.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer", rpm:"mplayer~1.0~1.rc2.10.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-doc", rpm:"mplayer-doc~1.0~1.rc2.10.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-gui", rpm:"mplayer-gui~1.0~1.rc2.10.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"mencoder", rpm:"mencoder~1.0~1.rc2.18.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer", rpm:"mplayer~1.0~1.rc2.18.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-doc", rpm:"mplayer-doc~1.0~1.rc2.18.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mplayer-gui", rpm:"mplayer-gui~1.0~1.rc2.18.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}