###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for wireshark MDVSA-2008:215 (wireshark)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830417);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:215");
  script_cve_id("CVE-2008-4680", "CVE-2008-4681", "CVE-2008-4682", "CVE-2008-4683", "CVE-2008-4684", "CVE-2008-4685");
  script_name(english: "Mandriva Update for wireshark MDVSA-2008:215 (wireshark)");
  desc["english"] = "

  Vulnerability Insight:

  A number of vulnerabilities were discovered in Wireshark that could
  cause it to crash or abort while processing malicious packets
  (CVE-2008-4680, CVE-2008-4681, CVE-2008-4682, CVE-2008-4683,
  CVE-2008-4684, CVE-2008-4685).
  
  This update provides Wireshark 1.0.4, which is not vulnerable to
  these issues.

  Affected Software/OS:
  wireshark on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00040.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"dumpcap", rpm:"dumpcap~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwireshark0", rpm:"libwireshark0~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwireshark-devel", rpm:"libwireshark-devel~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rawshark", rpm:"rawshark~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tshark", rpm:"tshark~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark-tools", rpm:"wireshark-tools~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wireshark0", rpm:"lib64wireshark0~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wireshark-devel", rpm:"lib64wireshark-devel~1.0.4~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"dumpcap", rpm:"dumpcap~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwireshark0", rpm:"libwireshark0~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwireshark-devel", rpm:"libwireshark-devel~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rawshark", rpm:"rawshark~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tshark", rpm:"tshark~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark-tools", rpm:"wireshark-tools~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wireshark0", rpm:"lib64wireshark0~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64wireshark-devel", rpm:"lib64wireshark-devel~1.0.4~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}