###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for metisse MDVSA-2008:179 (metisse)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830376);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:179");
  script_cve_id("CVE-2008-1379", "CVE-2008-2360", "CVE-2008-2361", "CVE-2008-2362");
  script_name(english: "Mandriva Update for metisse MDVSA-2008:179 (metisse)");
  desc["english"] = "

  Vulnerability Insight:

  An input validation flaw was found in X.org's MIT-SHM extension.
  A client connected to the X.org server could read arbitrary server
  memory, resulting in the disclosure of sensitive data of other users
  of the X.org server (CVE-2008-1379).
  
  Multiple integer overflows were found in X.org's Render extension.
  A malicious authorized client could explot these issues to cause a
  denial of service (crash) or possibly execute arbitrary code with
  root privileges on the X.org server (CVE-2008-2360, CVE-2008-2361,
  CVE-2008-2362).
  
  The Metisse program is likewise affected by these issues; the updated
  packages have been patched to prevent them.

  Affected Software/OS:
  metisse on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-08/msg00022.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of metisse");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libmetisse1", rpm:"libmetisse1~0.4.0~1.rc4.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmetisse1-devel", rpm:"libmetisse1-devel~0.4.0~1.rc4.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"metisse", rpm:"metisse~0.4.0~1.rc4.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"metisse-fvwm", rpm:"metisse-fvwm~2.5.20~1.rc4.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmetisse", rpm:"x11-server-xmetisse~0.4.0~1.rc4.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64metisse1", rpm:"lib64metisse1~0.4.0~1.rc4.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64metisse1-devel", rpm:"lib64metisse1-devel~0.4.0~1.rc4.10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libmetisse1", rpm:"libmetisse1~0.4.0~1.rc4.10.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmetisse1-devel", rpm:"libmetisse1-devel~0.4.0~1.rc4.10.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"metisse", rpm:"metisse~0.4.0~1.rc4.10.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"metisse-fvwm", rpm:"metisse-fvwm~2.5.20~1.rc4.10.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmetisse", rpm:"x11-server-xmetisse~0.4.0~1.rc4.10.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64metisse1", rpm:"lib64metisse1~0.4.0~1.rc4.10.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64metisse1-devel", rpm:"lib64metisse1-devel~0.4.0~1.rc4.10.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}