###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for timezone MDVA-2008:082 (timezone)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830563);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:082");
  script_cve_id("");
  script_name(english: "Mandriva Update for timezone MDVA-2008:082 (timezone)");
  desc["english"] = "

  Vulnerability Insight:

  Automatic mirror geolocation in drakxtools-backend in Mandriva
  Linux 2008.1 would fail for some locales, because it uses backward
  compatibility timezone names for which there were no zone.tab entries
  in timezone (bug #40184), this makes software like urpmi to not select
  optimal mirrors in its automatic media/mirrors addition mode.
  
  This update makes timezone provide backward timezone name entries in
  zone.tab file to solve this issue.
  
  Additionaly, updated timezone packages are being provided for older
  Mandriva Linux systems that do not contain the new Daylight Savings
  Time information for 2008 and later for certain time zones.

  Affected Software/OS:
  timezone on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00002.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of timezone");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"timezone-2008c", rpm:"timezone-2008c~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"timezone-2008c", rpm:"timezone-2008c~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"timezone-java-2008c", rpm:"timezone-java-2008c~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"timezone-2008c", rpm:"timezone-2008c~1.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"timezone-java-2008c", rpm:"timezone-java-2008c~1.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}