###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for xkeyboard-config MDVA-2008:055 (xkeyboard-config)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830382);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:055");
  script_cve_id("");
  script_name(english: "Mandriva Update for xkeyboard-config MDVA-2008:055 (xkeyboard-config)");
  desc["english"] = "

  Vulnerability Insight:

  Mandriva Linux 2008.1 introduced an improved Finnish default keyboard
  layout called Kotoistus.  This layout adds altgr-space as a key
  combination for non-breaking space.  However, that key combination can
  be easily hit accidentally when a normal space was intended instead,
  especially after typing the pipe character.  This update removes the
  new key combination.  Non-breaking space can still be typed via the
  traditional combination altgr-shift-space.

  Affected Software/OS:
  xkeyboard-config on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00001.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xkeyboard-config");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"x11-data-xkbdata", rpm:"x11-data-xkbdata~1.2~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xkeyboard-config", rpm:"xkeyboard-config~1.2~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}