###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for qt MDKSA-2007:183 (qt)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830124);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:183");
  script_cve_id("CVE-2007-4137");
  script_name(english: "Mandriva Update for qt MDKSA-2007:183 (qt)");
  desc["english"] = "

  Vulnerability Insight:

  A buffer overflow was found in how Qt expanded malformed Unicode
  strings.  If an application linked against Qt parsed a malicious
  Unicode string, it could lead to a denial of service or potentially
  allow for the execution of arbitrary code.
  
  Updated packages have been patched to prevent this issue.  Although the
  problem is not exploitable in Qt4, patched packages have been issued
  regardless.

  Affected Software/OS:
  qt on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-09/msg00014.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of qt");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libdesignercore1", rpm:"libdesignercore1~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libeditor1", rpm:"libeditor1~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqassistant1", rpm:"libqassistant1~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqassistantclient1", rpm:"libqassistantclient1~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3", rpm:"libqt3~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-devel", rpm:"libqt3-devel~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-mysql", rpm:"libqt3-mysql~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-odbc", rpm:"libqt3-odbc~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-psql", rpm:"libqt3-psql~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-sqlite", rpm:"libqt3-sqlite~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-static-devel", rpm:"libqt3-static-devel~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3support4", rpm:"libqt3support4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt4-devel", rpm:"libqt4-devel~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtcore4", rpm:"libqtcore4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtdbus4", rpm:"libqtdbus4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtdesigner1", rpm:"libqtdesigner1~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtgui4", rpm:"libqtgui4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtnetwork4", rpm:"libqtnetwork4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtopengl4", rpm:"libqtopengl4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtsql4", rpm:"libqtsql4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtsvg4", rpm:"libqtsvg4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqttest4", rpm:"libqttest4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtuitools4", rpm:"libqtuitools4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtxml4", rpm:"libqtxml4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-common", rpm:"qt3-common~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-doc", rpm:"qt3-doc~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-example", rpm:"qt3-example~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-tutorial", rpm:"qt3-tutorial~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-accessibility-plugin-lib", rpm:"qt4-accessibility-plugin-lib~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-assistant", rpm:"qt4-assistant~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-codecs-plugin-lib", rpm:"qt4-codecs-plugin-lib~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-common", rpm:"qt4-common~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-mysql-lib", rpm:"qt4-database-plugin-mysql-lib~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-odbc-lib", rpm:"qt4-database-plugin-odbc-lib~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-pgsql-lib", rpm:"qt4-database-plugin-pgsql-lib~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-sqlite-lib", rpm:"qt4-database-plugin-sqlite-lib~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-designer", rpm:"qt4-designer~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-doc", rpm:"qt4-doc~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-examples", rpm:"qt4-examples~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-linguist", rpm:"qt4-linguist~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-qvfb", rpm:"qt4-qvfb~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-tutorial", rpm:"qt4-tutorial~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3", rpm:"qt3~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4", rpm:"qt4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64designercore1", rpm:"lib64designercore1~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64editor1", rpm:"lib64editor1~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qassistant1", rpm:"lib64qassistant1~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qassistantclient1", rpm:"lib64qassistantclient1~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3", rpm:"lib64qt3~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-devel", rpm:"lib64qt3-devel~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-mysql", rpm:"lib64qt3-mysql~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-odbc", rpm:"lib64qt3-odbc~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-psql", rpm:"lib64qt3-psql~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-sqlite", rpm:"lib64qt3-sqlite~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-static-devel", rpm:"lib64qt3-static-devel~3.3.8~4.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3support4", rpm:"lib64qt3support4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt4-devel", rpm:"lib64qt4-devel~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtcore4", rpm:"lib64qtcore4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtdbus4", rpm:"lib64qtdbus4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtdesigner1", rpm:"lib64qtdesigner1~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtgui4", rpm:"lib64qtgui4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtnetwork4", rpm:"lib64qtnetwork4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtopengl4", rpm:"lib64qtopengl4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtsql4", rpm:"lib64qtsql4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtsvg4", rpm:"lib64qtsvg4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qttest4", rpm:"lib64qttest4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtuitools4", rpm:"lib64qtuitools4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtxml4", rpm:"lib64qtxml4~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-accessibility-plugin-lib64", rpm:"qt4-accessibility-plugin-lib64~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-codecs-plugin-lib64", rpm:"qt4-codecs-plugin-lib64~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-mysql-lib64", rpm:"qt4-database-plugin-mysql-lib64~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-odbc-lib64", rpm:"qt4-database-plugin-odbc-lib64~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-pgsql-lib64", rpm:"qt4-database-plugin-pgsql-lib64~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-sqlite-lib64", rpm:"qt4-database-plugin-sqlite-lib64~4.2.3~3.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libdesignercore1", rpm:"libdesignercore1~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libeditor1", rpm:"libeditor1~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqassistant1", rpm:"libqassistant1~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqassistantclient1", rpm:"libqassistantclient1~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3", rpm:"libqt3~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-devel", rpm:"libqt3-devel~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-mysql", rpm:"libqt3-mysql~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-odbc", rpm:"libqt3-odbc~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-psql", rpm:"libqt3-psql~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-sqlite", rpm:"libqt3-sqlite~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3-static-devel", rpm:"libqt3-static-devel~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3support4", rpm:"libqt3support4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt4-devel", rpm:"libqt4-devel~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtcore4", rpm:"libqtcore4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtdesigner1", rpm:"libqtdesigner1~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtgui4", rpm:"libqtgui4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtnetwork4", rpm:"libqtnetwork4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtopengl4", rpm:"libqtopengl4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtsql4", rpm:"libqtsql4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtsvg4", rpm:"libqtsvg4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqttest4", rpm:"libqttest4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtuitools4", rpm:"libqtuitools4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtxml4", rpm:"libqtxml4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-common", rpm:"qt3-common~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-doc", rpm:"qt3-doc~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-example", rpm:"qt3-example~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3-tutorial", rpm:"qt3-tutorial~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-accessibility-plugin-lib", rpm:"qt4-accessibility-plugin-lib~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-assistant", rpm:"qt4-assistant~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-common", rpm:"qt4-common~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-mysql-lib", rpm:"qt4-database-plugin-mysql-lib~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-odbc-lib", rpm:"qt4-database-plugin-odbc-lib~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-pgsql-lib", rpm:"qt4-database-plugin-pgsql-lib~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-sqlite-lib", rpm:"qt4-database-plugin-sqlite-lib~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-designer", rpm:"qt4-designer~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-doc", rpm:"qt4-doc~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-examples", rpm:"qt4-examples~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-linguist", rpm:"qt4-linguist~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-tutorial", rpm:"qt4-tutorial~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt3", rpm:"qt3~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4", rpm:"qt4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64designercore1", rpm:"lib64designercore1~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64editor1", rpm:"lib64editor1~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qassistant1", rpm:"lib64qassistant1~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qassistantclient1", rpm:"lib64qassistantclient1~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3", rpm:"lib64qt3~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-devel", rpm:"lib64qt3-devel~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-mysql", rpm:"lib64qt3-mysql~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-odbc", rpm:"lib64qt3-odbc~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-psql", rpm:"lib64qt3-psql~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-sqlite", rpm:"lib64qt3-sqlite~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3-static-devel", rpm:"lib64qt3-static-devel~3.3.6~18.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3support4", rpm:"lib64qt3support4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt4-devel", rpm:"lib64qt4-devel~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtcore4", rpm:"lib64qtcore4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtdesigner1", rpm:"lib64qtdesigner1~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtgui4", rpm:"lib64qtgui4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtnetwork4", rpm:"lib64qtnetwork4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtopengl4", rpm:"lib64qtopengl4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtsql4", rpm:"lib64qtsql4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtsvg4", rpm:"lib64qtsvg4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qttest4", rpm:"lib64qttest4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtuitools4", rpm:"lib64qtuitools4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtxml4", rpm:"lib64qtxml4~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-accessibility-plugin-lib64", rpm:"qt4-accessibility-plugin-lib64~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-mysql-lib64", rpm:"qt4-database-plugin-mysql-lib64~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-odbc-lib64", rpm:"qt4-database-plugin-odbc-lib64~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-pgsql-lib64", rpm:"qt4-database-plugin-pgsql-lib64~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-sqlite-lib64", rpm:"qt4-database-plugin-sqlite-lib64~4.1.4~12.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}