###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for krb5 MDKSA-2007:174-1 (krb5)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830272);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:174-1");
  script_cve_id("CVE-2007-3999", "CVE-2007-4000", "CVE-2007-4743");
  script_name(english: "Mandriva Update for krb5 MDKSA-2007:174-1 (krb5)");
  desc["english"] = "

  Vulnerability Insight:

  A stack buffer overflow vulnerability was discovered in the RPC
  library used by Kerberos' kadmind program by Tenable Network Security.
  A remote unauthenticated user who could access kadmind would be
  able to trigger the flaw and cause it to crash (CVE-2007-3999).
  This issue is only applicable to Kerberos 1.4 and higher.
  
  Garrett Wollman found an uninitialized pointer vulnerability in
  kadmind which a remote unauthenticated attacker able to access
  kadmind could exploit to cause kadmind to crash (CVE-2007-4000).
  This issue is only applicable to Kerberos 1.5 and higher.
  
  Update:
  
  The MIT Kerberos Team found a problem with the originally published
  patch for CVE-2007-3999.  A remote unauthenticated attacker able to
  access kadmind could trigger this flaw and cause kadmind to crash.
  
  Updated packages have been patched to prevent these issues.

  Affected Software/OS:
  krb5 on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-09/msg00007.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"ftp-client-krb5", rpm:"ftp-client-krb5~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ftp-server-krb5", rpm:"ftp-server-krb5~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-workstation", rpm:"krb5-workstation~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53", rpm:"libkrb53~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53-devel", rpm:"libkrb53-devel~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-client-krb5", rpm:"telnet-client-krb5~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-server-krb5", rpm:"telnet-server-krb5~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53", rpm:"lib64krb53~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53-devel", rpm:"lib64krb53-devel~1.5.2~6.5mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"ftp-client-krb5", rpm:"ftp-client-krb5~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ftp-server-krb5", rpm:"ftp-server-krb5~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-workstation", rpm:"krb5-workstation~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53", rpm:"libkrb53~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53-devel", rpm:"libkrb53-devel~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-client-krb5", rpm:"telnet-client-krb5~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-server-krb5", rpm:"telnet-server-krb5~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53", rpm:"lib64krb53~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53-devel", rpm:"lib64krb53-devel~1.4.3~7.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}