###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gtk+2.0 MDKSA-2007:039 (gtk+2.0)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830285);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:039");
  script_cve_id("CVE-2007-0010");
  script_name(english: "Mandriva Update for gtk+2.0 MDKSA-2007:039 (gtk+2.0)");
  desc["english"] = "

  Vulnerability Insight:

  The GdkPixbufLoader function in GIMP ToolKit (GTK+) in GTK 2 (gtk2)
  allows context-dependent attackers to cause a denial of service (crash)
  via a malformed image file. (CVE-2007-0010)
  
  The version of libgtk+2.0 shipped with Mandriva Linux 2007 fails
  various portions of the lsb-test-desktop test suite, part of LSB 3.1
  certification testing.
  
  The updated packages also address the following issues:
  
  The Home and Desktop entries in the GTK File Chooser are not always
  visible (#26644).
  
  GTK+-based applications (which includes all the Mandriva Linux
  configuration tools, for example) crash (instead of falling back to the
  default theme) when an invalid icon theme is selected. (#27013)
  
  Additional patches from GNOME CVS have been included to address the
  following issues from the GNOME bugzilla:
  
  * 357132 				- fix RGBA colormap issue
  
  * 359537,357280,359052 		- fix various printer bugs
  
  * 357566,353736,357050,363437,379503   - fix various crashes
  
  * 372527				- fix fileselector bug +
  
  potential deadlock

  Affected Software/OS:
  gtk+2.0 on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00008.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gtk+2.0");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"gtk+2.0", rpm:"gtk+2.0~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgdk_pixbuf2.0_0", rpm:"libgdk_pixbuf2.0_0~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgdk_pixbuf2.0_0-devel", rpm:"libgdk_pixbuf2.0_0-devel~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtk+-x11", rpm:"libgtk+-x11~2.0_0~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtk+2.0_0", rpm:"libgtk+2.0_0~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtk+2.0_0-devel", rpm:"libgtk+2.0_0-devel~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gdk_pixbuf2.0_0", rpm:"lib64gdk_pixbuf2.0_0~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gdk_pixbuf2.0_0-devel", rpm:"lib64gdk_pixbuf2.0_0-devel~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtk+-x11", rpm:"lib64gtk+-x11~2.0_0~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtk+2.0_0", rpm:"lib64gtk+2.0_0~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtk+2.0_0-devel", rpm:"lib64gtk+2.0_0-devel~2.10.3~5.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}